function plotCalibrationCurve( fit, xStr, yStr, calibrationType, eqStr )
    fig = figure;
    hold on
    plot( fit );
    grid on
    xlabel( xStr )
    ylabel( yStr )
    titleStr = calibrationType + " Calibration Curve";
    title( titleStr )
    ylim( [ 0, Inf ] )
    legend( "Location", "southeast" )
    
    annotation('textbox', [0.15, 0.75, 0.1, 0.1], ...
           'String', eqStr, ...
           'FitBoxToText', 'on', ...
           'FontSize', 14, ...
           'EdgeColor', 'none');

    hold off
    saveCalibrationPlot( fig, strrep( titleStr, " ", "" ) )
end