function handleConstantLoadPostProcessing( genName, fileName )
    genNameNoSpace = strrep( genName, " ", "" );
    [ constVals, constLoadType, constLoadVar, constLoadUnit ] = getConstantLoadValues( fileName );

    [ V, u_V, I, u_I, omega, u_omega, T, u_T ] = getExpandedMeasurements( fileName );

    rows = length( V( :, 1 ) ); columns = length( V( 1, : ) );

    for idx = 1 : columns
        [ V, u_V ] = removeNoThrottleInputData( V, u_V, omega );
        [ I, u_I ] = removeNoThrottleInputData( I, u_I, omega );
        [ T, u_T ] = removeNoThrottleInputData( T, u_T, omega );
        [ omega, u_omega ] = removeNoThrottleInputData( omega, u_omega, omega );
    end

    V_avg = zeros( rows / Constants.SAMPLE_AMT, columns ); u_V_avg = zeros( rows / Constants.SAMPLE_AMT, columns );
    I_avg = zeros( rows / Constants.SAMPLE_AMT, columns ); u_I_avg = zeros( rows / Constants.SAMPLE_AMT, columns );

    R = zeros( rows, columns ); u_R = zeros( rows, columns );
    R_avg = zeros( rows / Constants.SAMPLE_AMT, columns ); u_R_avg = zeros( rows / Constants.SAMPLE_AMT, columns );

    omega_avg = zeros( rows / Constants.SAMPLE_AMT, columns ); u_omega_avg = zeros( rows / Constants.SAMPLE_AMT, columns );
    T_avg = zeros( rows / Constants.SAMPLE_AMT, columns ); u_T_avg = zeros( rows / Constants.SAMPLE_AMT, columns );

    P_m = zeros( rows, columns ); u_P_m = zeros( rows, columns );
    P_m_avg = zeros( rows / Constants.SAMPLE_AMT, columns ); u_P_m_avg = zeros( rows / Constants.SAMPLE_AMT, columns );

    P_e = zeros( rows, columns ); u_P_e = zeros( rows, columns );
    P_e_avg = zeros( rows / Constants.SAMPLE_AMT, columns ); u_P_e_avg = zeros( rows / Constants.SAMPLE_AMT, columns );

    eta = zeros( rows, columns ); u_eta = zeros( rows, columns );
    eta_avg = zeros( rows / Constants.SAMPLE_AMT, columns ); u_eta_avg = zeros( rows / Constants.SAMPLE_AMT, columns );

    avgConstLoadCurve = initializeConstLoadCurves( genName, constLoadType, constLoadVar, constLoadUnit );
%     powerCurves3dFig = initializePowerCurves( genName, constLoadType, constLoadVar, constLoadUnit );
    avgPowerCurves3dFig = initializePowerCurves( genName, constLoadType, constLoadVar, constLoadUnit );
%     efficiencyCurves3dFig = initializeEfficiencyCurves( genName, constLoadType, constLoadVar, constLoadUnit );
    avgEfficiencyCurves3dFig = initializeEfficiencyCurves( genName, constLoadType, constLoadVar, constLoadUnit );

    for idx = 1 : columns
        [ R( :, idx ), u_R( :, idx ) ] = getResistance( V( :, idx ), u_V(:, idx ), I( :, idx ), u_I( :, idx ) );
        [ R_avg( :, idx ), u_R_avg( :, idx ) ] = getWeightedAverageData( R( :, idx ), u_R(:, idx ) );

        
        
        [ V_avg( :, idx ), u_V_avg( :, idx ) ] = getWeightedAverageData( V( :, idx ), u_V(:, idx ) );
        [ I_avg( :, idx ), u_I_avg( :, idx ) ] = getWeightedAverageData( I( :, idx ), u_I(:, idx ) );
        [ omega_avg( :, idx ), u_omega_avg( :, idx ) ] = getWeightedAverageData( omega( :, idx ), u_omega(:, idx ) );
        [ T_avg( :, idx ), u_T_avg( :, idx ) ] = getWeightedAverageData( T( :, idx ), u_T(:, idx ) );

        [ P_m( :, idx ), u_P_m( :, idx ) ] = getMechanicalPower( T( :, idx ), u_T( :, idx ), omega( :, idx ), u_omega( :, idx ) );
        [ P_e( :, idx ), u_P_e( :, idx ) ] = getElectricalPower( V( :, idx ), u_V( :, idx ), I( :, idx ), u_I( :, idx ) );

        [ P_m_avg( :, idx ), u_P_m_avg( :, idx ) ] = getWeightedAverageData( P_m( :, idx ), u_P_m( :, idx ) );
        [ P_e_avg( :, idx ), u_P_e_avg( :, idx ) ] = getWeightedAverageData( P_e( :, idx ), u_P_e( :, idx ) );

%         powerCurves3dFig = plotPowerCurves( powerCurves3dFig, V( :, idx ), P_m( :, idx ), P_e( :, idx ), constVals( idx ) );
        avgPowerCurves3dFig = plotPowerCurves( avgPowerCurves3dFig, V_avg( :, idx ), P_m_avg( :, idx ), P_e_avg( :, idx ), constVals( idx ) );

        [ eta( :, idx ), u_eta( :, idx ) ] = getEfficiency( P_m( :, idx ), u_P_m( :, idx ), P_e( :, idx ), u_P_e( :, idx ) );

        [ eta_avg( :, idx ), u_eta_avg( :, idx ) ] = getWeightedAverageData( eta( :, idx ), u_eta( :, idx ) );

%         efficiencyCurves3dFig = plotEfficiencyCurve( efficiencyCurves3dFig, omega( :, idx ), eta( :, idx ), constVals( idx ) );
        avgEfficiencyCurves3dFig = plotEfficiencyCurve( avgEfficiencyCurves3dFig, omega_avg( :, idx ), eta_avg( :, idx ), constVals( idx ) );

        if constLoadType == "Resistance"
            avgConstLoadCurve = plotConstLoadCurves( avgConstLoadCurve, constVals( idx ), R_avg( :, idx ), u_R_avg( :, idx ) );
        else % Current
            avgConstLoadCurve = plotConstLoadCurves( avgConstLoadCurve, constVals( idx ), I_avg( :, idx ), u_I_avg( :, idx ) );
        end
    end

%     saveData( V, u_V, genNameNoSpace, "RawVoltage", "Constant" + constLoadType );
    saveData( V_avg, u_V_avg, genNameNoSpace, "Voltage", "Constant" + constLoadType );
%     saveData( I, u_I, genNameNoSpace, "RawCurrent", "Constant" + constLoadType );
    saveData( I_avg, u_I_avg, genNameNoSpace, "Current", "Constant" + constLoadType );
%     saveData( R, u_R, genNameNoSpace, "RawResistance", "Constant" + constLoadType );
    saveData( R_avg, u_R_avg, genNameNoSpace, "Resistance", "Constant" + constLoadType );
%     saveData( omega, u_omega, genNameNoSpace, "RawSpeed", "Constant" + constLoadType );
    saveData( omega_avg, u_omega_avg, genNameNoSpace, "Speed", "Constant" + constLoadType );
%     saveData( T, u_T, genNameNoSpace, "RawTorque", "Constant" + constLoadType );
    saveData( T_avg, u_T_avg, genNameNoSpace, "Torque", "Constant" + constLoadType );
%     saveData( P_e, u_P_e, genNameNoSpace, "RawElectricalPower", "Constant" + constLoadType );
    saveData( P_e_avg, u_P_e_avg, genNameNoSpace, "ElectricalPower", "Constant" + constLoadType );
%     saveData( P_m, u_P_m, genNameNoSpace, "RawMechanicalPower", "Constant" + constLoadType );
    saveData( P_m_avg, u_P_m_avg, genNameNoSpace, "MechanicalPower", "Constant" + constLoadType );
%     saveData( eta, u_eta, genNameNoSpace, "RawEfficiency", "Constant" + constLoadType );
    saveData( eta_avg, u_eta_avg, genNameNoSpace, "Efficiency", "Constant" + constLoadType );

%     powerCurves3dFig = finalizePowerCurve( powerCurves3dFig );
%     fileName = genNameNoSpace + "Constant" + constLoadType + "PowerCurves.png";
%     savePlot( powerCurves3dFig, genName, fileName );

    avgPowerCurves3dFig = finalizePowerCurve( avgPowerCurves3dFig );
    fileName = genNameNoSpace + "Constant" + constLoadType + "AvgPowerCurves.png";
    savePlot( avgPowerCurves3dFig, genName, fileName );
    
%     efficiencyCurves3dFig = finalizeEfficiencyCurve( efficiencyCurves3dFig );
%     fileName = genNameNoSpace + "Constant" + constLoadType + "EfficiencyCurves.png";
%     savePlot( efficiencyCurves3dFig, genName, fileName );

    avgEfficiencyCurves3dFig = finalizeEfficiencyCurve( avgEfficiencyCurves3dFig );
    fileName = genNameNoSpace + "Constant" + constLoadType + "AvgEfficiencyCurves.png";
    savePlot( avgEfficiencyCurves3dFig, genName, fileName );

    avgConstLoadCurve = finalizeConstLoadCurves( avgConstLoadCurve );
    fileName = genNameNoSpace + "Constant" + constLoadType + "AvgLoadCurve.png";
    savePlot( avgConstLoadCurve, genName, fileName );
end