function [ P_m, u_P_m ] = getMechanicalPower( T, u_T, omega, u_omega )
    
    syms T_sym omegaSym

    eqSym = ( T_sym / 1000 ) .* ( 2 .* pi .* omegaSym ./ 60 );

    eqSymScalarParams = []; 
    eqSymArrParams = [ T_sym, omegaSym ]; 
    eqSymScalarArgs = []; 
    eqSymArrArgs = [ T, omega ]; 

    u_P_m_T = getErrorPropagatedUncertainty( eqSym, ...
                                             T_sym, ...
                                             u_T, ...
                                             eqSymScalarParams, ...
                                             eqSymArrParams, ...
                                             eqSymScalarArgs, ...
                                             eqSymArrArgs );

    u_P_m_omega = getErrorPropagatedUncertainty( eqSym, ...
                                                 omegaSym, ...
                                                 u_omega, ...
                                                 eqSymScalarParams, ...
                                                 eqSymArrParams, ...
                                                 eqSymScalarArgs, ...
                                                 eqSymArrArgs );

    P_m = solveEquation( eqSym, ...
                         eqSymScalarParams, ...
                         eqSymArrParams, ...
                         eqSymScalarArgs, ...
                         eqSymArrArgs );
    u_P_m = getTotalUncertainty( u_P_m_T, u_P_m_omega );
end