function [ KvVec, u_KvVec ] = getKvVector( V, u_V, omega, u_omega )
    syms V_sym omegaSym

    eqSym = omegaSym / V_sym;

    eqSymScalarParams = []; 
    eqSymArrParams = [ V_sym, omegaSym ];

    indicesToRemove = find( isnan( omega ) );
    V( indicesToRemove ) = [];
    omega( indicesToRemove ) = [];
    u_V( indicesToRemove ) = [];
    u_omega( indicesToRemove ) = [];

    eqSymScalarArgs = []; 
    eqSymArrArgs = [ V, omega ];

    u_KvVec_omega = getErrorPropagatedUncertainty( eqSym, ...
                                                 omegaSym, ...
                                                 u_omega, ...
                                                 eqSymScalarParams, ...
                                                 eqSymArrParams, ...
                                                 eqSymScalarArgs, ...
                                                 eqSymArrArgs );

    u_KvVec_V = getErrorPropagatedUncertainty( eqSym, ...
                                                 V_sym, ...
                                                 u_V, ...
                                                 eqSymScalarParams, ...
                                                 eqSymArrParams, ...
                                                 eqSymScalarArgs, ...
                                                 eqSymArrArgs );

    KvVec = solveEquation( eqSym, ...
                        eqSymScalarParams, ...
                        eqSymArrParams, ...
                        eqSymScalarArgs, ... 
                        eqSymArrArgs );
    u_KvVec = getTotalUncertainty( u_KvVec_V, u_KvVec_omega );
end