function [ V, u_V, I, u_I, omega, u_omega, T, u_T ] = getExpandedMeasurements( fileName )
    sheetNames = sheetnames( fileName );
    sheetNamesLen = length( sheetNames );

    for idx = 1 : sheetNamesLen
        measurements = readmatrix( fileName, "Sheet", sheetNames( idx ) );

        voltageAdcCount = measurements( :, 2 );
        [ V_col, u_V_col ] = getVoltage( voltageAdcCount, true, false ); 
    
        currentAdcCount = measurements( :, 4 );
        [ I_col, u_I_col ] = getCurrent( currentAdcCount );
    
        omegaPrime = measurements( :, 6 );
        [ omega_col, u_omega_col ] = getSpeed( omegaPrime );
    
        torqueAdcCount = measurements( :, 8 );
        [ T_col, u_T_col ] = getTorque( torqueAdcCount );

        V( :, idx ) = V_col;
        u_V( :, idx ) = u_V_col;
        I( :, idx ) = I_col;
        u_I( :, idx ) = u_I_col;
        omega( :, idx ) = omega_col;
        u_omega( :, idx ) = u_omega_col;
        T( :, idx ) = T_col;
        u_T( :, idx ) = u_T_col;
    end
end