function [ fit, slope, intercept, confidenceInterval ] = getCalibrationCurve( x, y )

    fit = fitlm( x, y, "linear", "intercept", true );

    intercept = fit.Coefficients.Estimate( 1 );
    slope = fit.Coefficients.Estimate( 2 );
    
    N = length( y );
    dof = fit.DFE;
    syx = fit.RMSE;
    alphaup = 1 - 0.05 / 2;
    studentsT = tinv( alphaup, dof );
    confidenceInterval = studentsT * syx / sqrt( N );
end

