classdef Constants
    properties ( Constant )
        REFERENCE_VOLTAGE = 4.57; % V
        REFERENCE_VOLTAGE_UNCERTAINTY = 0.01; % V
        NUM_OF_BITS = 10;
        SAMPLE_AMT = 5;
        VOLTAGE_CALIBRATION_FILE_PATH = "./CalibrationData/VoltageCalibrationData.xlsx";
        CURRENT_CALIBRATION_FILE_PATH = "./CalibrationData/CurrentCalibrationData.xlsx";
        TORQUE_CALIBRATION_FILE_PATH = "./CalibrationData/TorqueCalibrationData.xlsx";
        CURRENT_SENSOR_SENSITIVITY = 0.066 % V/A
        ARDUINO_CLOCK_FREQUENCY = 16 * 10^6; % cycles/s
        PRESCALER = 256;
        ARDUINO_CLOCK_FREQUENCY_UNCERTAINTY_PERCENTAGE = 0.5; % Percentage
        RESISTANCE1 = 9.92 % kOhms
        RESISTANCE1_UNCERTAINTY = 0.01; % kOhms
        RESISTANCE2 = 0.995; %kOhms;
        RESISTANCE2_UNCERTAINTY = 0.001; % kOhms
        SPEED_UNCERTAINTY_PERCENTAGE = 2; % Percentage
        MOMENT_ARM_MASS = 0.029 %kg
        MOMENT_ARM_CENTROID = 98.59; % mm
        MOMENT_ARM_APPLIED_DISTANCE = 250; % mm
        GRAVITATIONAL_CONSTANT = 9.81; % m/s^2
        MARKER_SIZE = 20;
        RESULTS_FILE_PATH = "./Results/";
        CALIBRATION_RESULTS_FILE_PATH = "./Results/Calibration/";
        MAX_SPEED = 5600; % RPM (Based on Dyno's external motor)
        MAX_VOLTAGE = 48; % V (Based on CWC GEN '25 engineering requirements)
        
    end
end