// Preprocessor directives
#ifndef SENSOR_H
#define SENSOR_H

// Header files
#include "Arduino.h"

#define MAX_UNIT_STR_LEN 5

/*
Name: Sensor
Description: An abstract class that is used for sensors that are integrated in
             the Arduino. This class will not be used since it is a template
             for other sensors.
Dependencies: None
*/
class Sensor {

  // Protected variables for derived sensors
  protected:

    // Initialize variables

      // To store current measurement
      float measurement; 

      // The digital output of a measurement for error propagation
      float digitalMeasurement;

      // To store measurement unit
      char unit[ MAX_UNIT_STR_LEN ];

      // To store the amount of samples to take for each reading before storing
      // in measurment
      unsigned int sampleAmt;

      float calCurveSlope;
      float calCurveIntercept;

  public:
    virtual void initialize() = 0;
    virtual void measure() = 0;

    virtual float getMeasurement()
    {
      return measurement;
    }

    virtual float getDigitalMeasurement()
    {
      return digitalMeasurement;
    }

    virtual const char *getUnit() 
    {
      return unit;
    }
};

#endif // SENSOR_H