// Header files
#include "LcdScreen.h"

LcdScreen::LcdScreen( const int i2cAddress, 
                      const int numOfColumns, 
                      const int numOfRows ) : 
                      screen( i2cAddress, numOfColumns, numOfRows ) 
{
  cols = numOfColumns;
  rows = numOfRows;
}

void LcdScreen::initialize() {
  screen.init();
  screen.backlight();
  screen.clear();
}

void LcdScreen::print( const char *string, const int line ) {
  screen.setCursor( 0, line );
  screen.print( string );
}

void LcdScreen::printUnit( const char *unit, const int line ) {
  int unitLength = strlen( unit );
  int unitCursorPosition = cols - unitLength;
  screen.setCursor( unitCursorPosition, line );
  screen.print( unit );
}

void LcdScreen::printValue( const float value, const int line ) {
  screen.setCursor( 0, line );
  screen.print( value, DECIMAL_PLACES_TO_DISPLAY );
}

void LcdScreen::clearChars( const int line, const int endingColumn = COLUMNS ) {  
  screen.setCursor( 0, line );
  for( int currCol = 0; currCol < endingColumn; currCol++ ) {
    clearChar();
  }
}

void LcdScreen::clearValue( const int line, const int unitLength ) {
  int endingColumn = cols - unitLength;
  clearChars( line, endingColumn );
}

void LcdScreen::clearChar(){
  screen.print( SPACE );
}

void LcdScreen::clearScreen() {
  for ( int line = 0; line < rows; line++ ) {
    clearChars( line );
  }
}

void LcdScreen::printMeasurement( const float measurement, const char *unit, const int line ) {
  int unitLength = strlen( unit );
  clearValue( line, unitLength );
  printValue( measurement, line );
}