// Preprocessor directives
#ifndef CURRENT_SENSOR_H
#define CURRENT_SENSOR_H

// Header files
#include "Sensor.h"
#include "ArduinoUtilities.h"

// Constants
#define CURRENT_SENSOR_SENSITIVITY 0.066 // V/A
#define CURRENT_SENSOR_CALIBRATION_CURVE_SLOPE 1.3129
#define CURRENT_SENSOR_CALIBRATION_CURVE_INTERCEPT 0.2959
#define CURRENT_SENSOR_SAMPLE_AMT 1

// Current Sensor
class CurrentSensor : public Sensor {

  public:
    CurrentSensor( const int analogPin, 
                   const float sensitivity, 
                   const char *currentUnit, 
                   const unsigned int num_of_samples = 1,
                   const float calibrationCurveSlope = 1,
                   const float calibrationCurveIntercept = 0,
                   const float voltageCalibrationCurveSlope = 1,
                   const float voltageCalibrationCurveIntercept = 0 );

    void initialize() override;

    void measure() override;

  private:
    int aPin;
    float s;
    float rawCurrentVoltage;
    float voltageCalCurveSlope;
    float voltageCalCurveIntercept;
};

#endif // CURRENT_SENSOR_H