/*************************************************************************
 *
 *    File Name: textfield.c
 *
 *    Description:
 *
 *    History:
 *       20 Mar 2000: Created; Joshua Colvin
 *       30 Mar 2000: Added comment headers; Jason Campbell
 *       01 Apr 2000: Filled in comment headers; Joshua Colvin
 *
 *************************************************************************
 * Copyright (C) 2000 Jason Campbell, Joshua Colvin, Jason Sherrill,
 *                    Ben Tobin
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, In., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 *************************************************************************/


#include <PalmOS.h>

#include "textfield.h"

/*************************************************************************
 *
 *    Function Name: TextFieldFromHandle
 *
 *    Purpose:       Fill text field using handle
 *
 *    Parameters:    fieldID: ID of field to fill
 *                   txtH:    unlocked handle to text to use
 *
 *    Return Value:  pointer to field that was modified 
 *
 *
 *************************************************************************/
FieldPtr TextFieldFromHandle(UInt16 fieldID, MemHandle txtH)
{
	MemHandle oldTxtH;
	FormPtr frm = FrmGetActiveForm();
	FieldPtr fldP;

	// get the field and the field's current text handle.
	fldP   = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, fieldID));
	ErrNonFatalDisplayIf(!fldP, "missing field");
	oldTxtH = FldGetTextHandle(fldP);

	// set the field's text to the new text.
	FldSetTextHandle(fldP, txtH);

//	FldSetMaxChars(fldP, 12288); // Set to max possible in docwho.rcp

	FldDrawField(fldP);

	// free the handle AFTER we call FldSetTextHandle().
	if (oldTxtH)
	{
		MemHandleFree(oldTxtH);
	}

	return fldP;
}

/*************************************************************************
 *
 *    Function Name: TextFieldFromStr
 *
 *    Purpose:       Allocates new handle and copies incoming string,
 *                    calling TextFieldFromHandle to fill text field
 *
 *    Parameters:    fieldID: ID of field to fill
 *                   strP:    pointer to text string to use
 *
 *    Return Value:  Pointer to field that was modified
 *
 *
 *************************************************************************/
FieldPtr TextFieldFromStr(UInt16 fieldID, Char *strP)
{
	MemHandle txtH;
	
	// get some space in which to stash the string.
	txtH = MemHandleNew(StrLen(strP) + 1);
	if (!txtH)
	{
		return NULL;
	}
	
	// copy the string to the locked handle.
	StrCopy(MemHandleLock(txtH), strP);
	
	// unlock the string handle.
	MemHandleUnlock(txtH);
	
	// set the field to the handle
	return TextFieldFromHandle(fieldID, txtH);
}


/*************************************************************************
 *
 *    Function Name: TextFieldClear
 *
 *    Purpose:       Remove text handle from text field
 *
 *    Parameters:    fieldID: ID of field to remove text handle from
 *
 *    Return Value:  none
 *
 *
 *************************************************************************/
void TextFieldClear(UInt16 fieldID)
{
	TextFieldFromHandle(fieldID, NULL);
}


