/*************************************************************************
 *
 *    File Name: docdetails.c
 *
 *    Description: Functions relating to the doc details dialog box
 *
 *    History:
 *       14 Apr 2000: Created; Joshua Colvin
 *
 *************************************************************************
 * Copyright (C) 2000 Jason Campbell, Joshua Colvin, Jason Sherrill,
 *                    Ben Tobin
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, In., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 *************************************************************************/

#include <PalmOS.h>
#include "docwhoRsc.h"
#include "doclistdb.h"
#include "control.h"
#include "doclist.h"  // for the frmUpdateTableEvent #define


// Private function prototypes
static void DocDetailsFormInit(FormPtr frmP);
static Boolean DocDetailsHandleControlSelect (EventPtr eventP);

// Application-wide Global variable for keeping track of current
//  Doc file
extern UInt16 gCurrentDocIndex;

// Global variables for initializing controls
UInt16 gCardNo;
LocalID gDbID;
Char gName[dmDBNameLength];
UInt16 gAttributes;
UInt32 gCrDate;
UInt32 gModDate;
UInt32 gBckUpDate;
UInt16 gCategory;

Char gCategoryName[dmCategoryLength];

/*************************************************************************
 *
 *    Function Name: DocDetailsFormInit
 *
 *    Purpose:       Initialize global variables and setup category box
 *
 *    Parameters:    frmP: pointer to DocDetailsForm
 *
 *    Return Value:  none
 *
 *
 *************************************************************************/
static void DocDetailsFormInit(FormPtr frmP)
{
	ControlPtr triggerP;
	DocListDBGetInfo(gCurrentDocIndex,
	                 &gCardNo,
	                 &gDbID,
	                 gName,
	                 &gAttributes,
	                 &gCrDate,
	                 &gModDate,
	                 &gBckUpDate);
	
	gCategory = DocListDBGetCategory(gCurrentDocIndex);
	DocListDBCategoryGetName(gCategory, gName);
	
	// Setup category pulldown list
	// ####
	DocListDBCategoryGetName(gCategory, gName);
	triggerP = ControlGetPtrByID(frmP, DocListCategoryPopup);
	CategorySetTriggerLabel(triggerP, gName);

	
}

/*************************************************************************
 *
 *    Function Name: DocDetailsHandleControlSelect
 *
 *    Purpose:       Handle events for DocDetailsForm (dialog box)
 *
 *    Parameters:    eventP: pointer to event to be processed
 *
 *    Return Value:  true only if handled
 *
 *
 *************************************************************************/
static Boolean DocDetailsHandleControlSelect (EventPtr eventP)
{
	FormPtr frmP;
	Boolean handled;


	handled = false;
	switch(eventP->data.ctlSelect.controlID)
	{
		case DocDetailsOKButton:
			// Apply any changes made
			// ####

			DocListDBUpdateCategory(gCurrentDocIndex,gCategory);
			FrmReturnToForm(0); // Return to last active form
			// Redraw Doc list
			FrmUpdateForm(DocListForm, frmUpdateEventReloadDBAndTable);

			handled = true;
			break;
		case DocDetailsCancelButton:
			// Ignore any changes made
			FrmReturnToForm(0); // Return to last active form
			handled = true;
			break;
		case DocListCategoryPopup:
		 	frmP = FrmGetActiveForm();
	
			DocListDBCategorySelect(frmP, DocListCategoryPopup,
	                  DocListCategoryList, false, &gCategory, gName);
			handled = true;
			break;

	}
	
	return handled;		
}
/*************************************************************************
 *
 *    Function Name: DocDetailsFormHandleEvent
 *
 *    Purpose:       Handle events for DocDetailsForm (dialog box)
 *
 *    Parameters:    eventP: pointer to event to be processed
 *
 *    Return Value:  true only if handled
 *
 *
 *************************************************************************/
Boolean DocDetailsFormHandleEvent (EventPtr eventP)
{
	Boolean handled;
	FormPtr frmP;
	
	handled = false;
	switch (eventP->eType)
	{
		case frmOpenEvent:
			// Initialize and draw form
			frmP = FrmGetActiveForm();
			DocDetailsFormInit(frmP);
			FrmDrawForm(frmP);
			handled = true;
			break;
		
		case ctlSelectEvent:
			handled = DocDetailsHandleControlSelect(eventP);
			break;
		
		default:
			break;
	}
	
	return handled;
}

/*

static void DocListHandleCategorySelect(FormPtr frmP)
{
	Boolean categoryEdited;
	UInt16 category;
	
	category = gCategory;
	
	categoryEdited = DocListDBCategorySelect(frmP, DocListCategoryPopup,
	                  DocListCategoryList, true, &category,
	                  gName);
   
	// Check if DocList needs to be updated               

}


*/
