/*************************************************************************
 *
 *    File Name:   version.h
 *
 *    Description: Check and set version numbers
 *
 *    History:
 *       12 Apr 2000: Created; Joshua Colvin
 *
 *************************************************************************
 * Copyright (C) 2000 Jason Campbell, Joshua Colvin, Jason Sherrill,
 *                    Ben Tobin
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, In., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 *************************************************************************/


#define RomVer2_0    0x02000000    // Version 2.0 (better UI support)
#define RomVer3_0    0x03000000    // Version 3.0 (beaming support)

// The current version of DocListDB (older versions will be deleted)
#define CurrentDocListDBVersion 2

Boolean VersionCheckOS(UInt32 desiredVersion);

Boolean VersionCheckOpenDB(DmOpenRef dbP, UInt16 desiredVersion);

void VersionSetOpenDB(DmOpenRef dbP, UInt16 newVersion);
