/*************************************************************************
 *
 *	File Name:   doc.h
 *
 *	Description: Header file for doc.c
 *
 *	History:
 *	   20 Mar 2000: Created; Jason Sherrill
 *	   30 Mar 2000: Added comment headers; Jason Campbell
 *
 *************************************************************************
 * Copyright (C) 2000 Jason Campbell, Joshua Colvin, Jason Sherrill,
 *					Ben Tobin
 * 
 * This program is free software; you can redustribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, In., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 *************************************************************************/

#ifndef _DOC_H_
#define _DOC_H_


// Function Prototypes
MemHandle DocOpen(UInt16 cardNum, LocalID dbID);
void DocClose(Boolean isEdited);
MemHandle DocMasterScroll(WinDirectionType dir, Boolean isEdited, UInt16* changed, Boolean* s);
void DocGetRecords(UInt16 startRec, UInt8 numRecs);
UInt16 DocSaveRecord(UInt16 recNum, MemPtr startAddr, UInt16 decLen);


typedef struct		// Standard Doc format Header, record Zero
{
	UInt16	version;	// 1 = plain text, 2 = compressed text
	UInt16	spare;	// unknown, set to 0, sometimes 0x0003
	UInt32	length;	// uncompressed size in bytes
	UInt16	numRecs;	// # of text records, not including this one
	UInt16	recSize;	// in bytes, usually 4096 (0x1000)
	UInt32	position;	// currently viewed position in Doc
//	UInt16*	sizes;	// array giving uncompressed size of each record
}
DocRec0Type;

typedef struct		// Standard Bookmark footer records
{
	Char	bmName[16];	 // Bookmark name, 15 characters + '\0'
	UInt32	bmPosition;	 // byte number position in uncompressed text
}
BookmarkType;


#endif // _DOC_H_
