/*************************************************************************
 *
 *    File Name:   database.h
 *
 *    Description: Information needed to access and/or create databases
 *                  used by docwho
 *
 *    History:
 *       27 Apr 2000: Created; Joshua Colvin
 *       27 Apr 2000: Copied Doc file structs from doc.h; Joshua Colvin
 *
 *************************************************************************
 * Copyright (C) 2000 Jason Campbell, Joshua Colvin, Jason Sherrill,
 *                    Ben Tobin
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, In., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 *************************************************************************/

// Default card number to use for saving databases
#define DefaultCardNo 0

// Default size of Doc file records
#define DefaultDocRecordSize 4096

// Identifiers for temporary database
// docDBCreator == DocWhoCreatorID
#define DocDBType     'DATA'
#define DocDBName     "DocWhoDB"

// Identifiers for Doc files
#define DocCreator    'REAd'
#define DocType       'TEXt'
// docName == many different names

#define NewDocName    "NewDoc"


typedef struct		// Standard Doc format Header, record Zero
{
	UInt16	version;	// 1 = plain text, 2 = compressed text
	UInt16	spare;	// unknown, set to 0, sometimes 0x0003
	UInt32	length;	// uncompressed size in bytes
	UInt16	numRecs;	// # of text records, not including this one
	UInt16	recSize;	// in bytes, usually 4096 (0x1000)
	UInt32	position;	// currently viewed position in Doc
	UInt16	*sizes;	// array giving uncompressed size of each record
}
DocRec0Type;

typedef struct		// Standard Bookmark footer records
{
	Char		bmName[16];	 // Bookmark name, 15 characters + '\0'
	UInt32	bmPosition;	 // byte number position in uncompressed text
}
BookmarkType;

