'use strict';

var assert = require('chai').assert;
var expect = require('chai').expect

var proxyquire = require('proxyquire').noCallThru().noPreserveCache();
var Basket = require('../../../../../mocks/Basket');
var Logger = require('../../../../../mocks/dw/system/Logger');
var TaxMgr = require('../../../../../mocks/dw/order/TaxMgr');
var ProductLineItem = require('../../../../../mocks/dw/order/ProductLineItem');
var Money = require('../../../../../mocks/dw/value/Money');
var collections = require('../../../../../mocks/util/collections');

describe('externalTaxesHelpers', function () {
    global.testExternalTaxesHelpers = {
        testEnd: 0
    }
    var externalTaxesHelpers = proxyquire("../../../../../../social_checkout/cartridges/int_social_checkout/cartridge/scripts/util/externalTaxesHelpers.js", {
        'dw/system/Logger': Logger,
        'dw/order/TaxMgr': TaxMgr,
        '*/cartridge/scripts/util/collections': collections,
        'dw/value/Money': Money,
        'dw/order/ProductLineItem': ProductLineItem
    });

    it('calculateTaxRate: Get calculated percentage', function() {
        var taxAmount = '';
        var adjustedNetPrice = {
            currencyCode: ''
        };
        var response = externalTaxesHelpers.calculateTaxRate(taxAmount, adjustedNetPrice);
        
        assert.equal(response, 0.1);
    });

    it('updateExternalTaxesProductLineItems: Update External Taxes', function() {
        var basket = new Basket();
        var adjustedNetPrice = {
            currencyCode: ''
        };

        var testFn = externalTaxesHelpers.updateExternalTaxesProductLineItems;
        expect(function() { return testFn(basket); }).not.to.Throw();
        
    });

    it('updateExternalTaxesProductLineItems: JSON error', function() {
        var basket = {
            custom: {
                productExternalTaxes: {}
            }
        };
        var adjustedNetPrice = {
            currencyCode: ''
        };
        
        var badFn = externalTaxesHelpers.updateExternalTaxesProductLineItems;

        expect(function() { return badFn(basket); }).to.Throw();
    });
    
    it('updateTaxPriceAdjustments: updating tax price adjustments on property shippingLineItem', function() {
        var basket = new Basket();
        var lineItem = basket.productLineItems[0];
        var taxRate = 10;
        var lineItemType = 'shippingLineItem'; //'shippingLineItem', 'shippingPriceAdjustments' or 'priceAdjustments'
        var isOrder = true; // true or false

        var testFn = externalTaxesHelpers.updateTaxPriceAdjustments;
        
        expect(function() { return testFn(lineItem, taxRate, lineItemType, isOrder); }).not.to.Throw();
    });

    it('updateExternalTaxesLineItems', function() {
        var basket = new Basket();
        var order = {
            custom: {
                externalTaxes: 10
            },
            allLineItems: basket.productLineItems,
            priceAdjustments: [{
                setTaxClassID: function () {
                    return;
                },
                updateTax: function () {
                    return;
                }
        }],
            getCurrencyCode() { return 'USD'; },
            updateTotals() {return}
        };
        var orderInput = {
            c_externalTaxes: {
                get: function () {
                    return {
                        tax: 10
                    }
                }
            }
        }

        expect(function() { return externalTaxesHelpers.updateExternalTaxesLineItems(order, orderInput); }).not.to.Throw();
    });
});