var assert = require('chai').assert;
var SomPaymentModel = require('../../../../../social_checkout/cartridges/int_order_som/cartridge/models/somPayment.js');


var somApiOrderPayment = {
    '_1OsHp0000011RGZKA2': {
        '_1DWHp000000GmlqOAC': {
            'DisplayCardNumber': '3600 6666 3333 44',
            'CardHolderName': 'Peter Parker',
            'ExpiryMonth': 	'03',
            'ExpiryYear': '2030',
            'CardCategory': 'Dinners',
            'CardType': 'Credit',
            'CardTypeCategory': 'CreditCard'
        }
    }
};

var orderSummaryId = '1OsHp0000011RGZKA2';
var orderPaymentMethodId = '1DWHp000000GmlqOAC';


describe('somPayment', function () {
    it('should receive a null somApiOrderPayment object and have to show blank information', function () {
        var result = new SomPaymentModel(null, orderSummaryId, orderPaymentMethodId);
        assert.equal(result.DisplayCardNumber, '-');
        assert.equal(result.CardHolderName, '-');
        assert.equal(result.ExpiryMonth, '-');
        assert.equal(result.ExpiryYear, '-');
        assert.equal(result.CardCategory, '-');
        assert.equal(result.CardType, '-');
        assert.equal(result.CardTypeCategory, '-');
    });

    it('should receive a null orderSummaryId and have to show blank information', function () {
        var result = new SomPaymentModel(somApiOrderPayment, null, orderPaymentMethodId);
        assert.equal(result.DisplayCardNumber, '-');
        assert.equal(result.CardHolderName, '-');
        assert.equal(result.ExpiryMonth, '-');
        assert.equal(result.ExpiryYear, '-');
        assert.equal(result.CardCategory, '-');
        assert.equal(result.CardType, '-');
        assert.equal(result.CardTypeCategory, '-');
    });

    it('should receive a null orderPaymentMethodId and have to show blank information', function () {
        var result = new SomPaymentModel(somApiOrderPayment, orderSummaryId, null);
        assert.equal(result.DisplayCardNumber, '-');
        assert.equal(result.CardHolderName, '-');
        assert.equal(result.ExpiryMonth, '-');
        assert.equal(result.ExpiryYear, '-');
        assert.equal(result.CardCategory, '-');
        assert.equal(result.CardType, '-');
        assert.equal(result.CardTypeCategory, '-');
    });

    it('should convert SOM Order Payment API data to an object', function () {
        var result = new SomPaymentModel(somApiOrderPayment, orderSummaryId, orderPaymentMethodId);
        assert.equal(result.DisplayCardNumber, '3600 6666 3333 44');
        assert.equal(result.CardHolderName, 'Peter Parker');
        assert.equal(result.ExpiryMonth, '03');
        assert.equal(result.ExpiryYear, '2030');
        assert.equal(result.CardCategory, 'Dinners');
        assert.equal(result.CardType, 'Credit');
        assert.equal(result.CardTypeCategory, 'CreditCard');
    });
});