'use strict';

const Assert = require('chai').assert;
const Proxy = require('proxyquire').noCallThru().noPreserveCache();

var serviceHelper = require('../../../../mocks/serviceHelper');

describe('instagramService', function () {
    const instagramService = Proxy('../../../../../social_channels/cartridges/int_instagram/cartridge/scripts/services/instagramService', {
        'dw/system/Logger': {
            getLogger: function() {
                return {
                    info: function() {
                
                    }
                }
            },
            
        },
        'dw/system/Site': {

        },

        'dw/util/StringUtils': {
            'format': function () {
                
            }
        },
        'dw/system/System': {
            getInstanceType: function() {
                return 0;
            },
            getInstanceHostname: function() {
                return 'zzeu-000.dx.commercecloud.salesforce.com';
            }
        },
        './serviceHelper': new serviceHelper(),  
    });

    it('It should disconnect MBE', function () {
        var disconnectMBE = instagramService.disconnectMBE({
            custom: {
                accessToken: '',
                externalBusinessId: ''
            }
        }, '', '')
        Assert.strictEqual(disconnectMBE.error, false);
    });
});