'use strict';

const { expect } = require('chai');

const Assert = require('chai').assert;
const Proxy = require('proxyquire').noCallThru().noPreserveCache();

describe('InstagramConstants', function () {

    const InstagramConstants = Proxy('../../../../social_channels/cartridges/int_instagram/cartridge/scripts/InstagramConstants.js', {
    });

    it('It should get SOCIAL_CHANNEL_CUSTOM_OBJECT_DEFINITION', function () {
        Assert.equal(InstagramConstants.SOCIAL_CHANNEL_CUSTOM_OBJECT_DEFINITION, 'SocialChannels');
    });

    it('It should get SOCIAL_CHANNEL_CUSTOM_OBJECT_FEED_CONFIG', function () {
        Assert.equal(InstagramConstants.SOCIAL_CHANNEL_CUSTOM_OBJECT_FEED_CONFIG, 'SalesChannelFeedConfig');
    });

    it('It should get INSTAGRAM_CUSTOM_OBJECT_ID', function () {
        Assert.equal(InstagramConstants.INSTAGRAM_CUSTOM_OBJECT_ID, 'instagram-settings');
    });

    it('It should get LOGGER_NAME', function () {
        Assert.equal(InstagramConstants.LOGGER_NAME, 'instagram');
    });

    it('It should get API_VERSION', function () {
        Assert.equal(InstagramConstants.API_VERSION, 'v19.0');
    });

    it('It should get APP_ID', function () {
       Assert.equal(InstagramConstants.APP_ID, "414303402113306");
    });

    it('It should get ENDPOINTS', function () {
        var VERSION = 'v19.0';
        var expectResult = {
            COMMERCE_EXTENSION: '/fbe_business/?fbe_external_business_id={0}&access_token={1}&fields=commerce_extension',
            FEED_NOTIFICATION: '/' + VERSION + '/{0}/file_update',
            MBE_CONNECTION: '/' + VERSION + '/fbe_business/fbe_installs?fbe_external_business_id={0}&access_token={1}',
            VALIDATE_TOKEN: '/' + VERSION + '/me?fields=id,name&access_token={0}',
            SPLASH_EXTENSION: 'https://www.commercepartnerhub.com/commerce_extension/splash/?app_id={0}&external_business_id={1}&business_name={2}&currency={3}&timezone={4}&external_client_metadata={5}&business_vertical={6}&channel={7}',
            POST_ONBOARDING: '/' + VERSION + '/{0}/post_onboarding_data'
        }
        expect(InstagramConstants.ENDPOINTS).to.deep.equal(expectResult)
    });

    it('It should get SERVICES', function () {
        var expectResult = {
            INSTAGRAM: {
                BASE: 'facebook.graph'
            }
        }
        expect(InstagramConstants.SERVICES).to.deep.equal(expectResult)
    });

    it('It should get SERVICE_RETRY_COUNT', function () {
        Assert.equal(InstagramConstants.SERVICE_RETRY_COUNT, 3);
    });
});