'use strict';

const assert = require('chai').assert;
const Proxy = require('proxyquire').noCallThru().noPreserveCache();
const Basket = require('../../../../mocks/Basket');

const baseMyHelper = Proxy('../../../../../social_checkout/cartridges/int_google_checkout/cartridge/scripts/utils/LinkHelpers.js', {});
Object.setPrototypeOf(module, Object.assign(Object.getPrototypeOf(module), {
    superModule: baseMyHelper

})); // module.__proto__.superModule can also be used but lint doesn't like it (see no-proto rule)

var linkHelper= Proxy('../../../../../social_checkout/cartridges/int_google_tempbasket_addon/cartridge/scripts/utils/LinkHelpers.js', {
    'dw/web/URLUtils': require('../../../../mocks/dw/web/URLUtils'),
});
String.__proto__.concat = function () { return false; }


describe('Google Temp Basket - Link Helpers', function () {

    it('It should generate the URL Google perm link based on basket product line items, link for checkout', function () {
        var basket = new Basket;
        var generateGooglePermLinks = linkHelper.generateGooglePermLinks(basket, true);
        assert.isObject(generateGooglePermLinks);
    });

    it('It should generate the URL Google perm link based on basket product line items, link for cart', function () {
        var basket = new Basket;
        var generateGooglePermLinks = linkHelper.generateGooglePermLinks(basket, false);
        assert.isObject(generateGooglePermLinks);
    });
});