'use strict';

const assert = require('chai').assert;
const Proxy = require('proxyquire').noCallThru().noPreserveCache();
const BasketMgr = require('../../../../../mocks/dw/order/BasketMgr');

const baseMyHelper = {};
Object.setPrototypeOf(module, Object.assign(Object.getPrototypeOf(module), {
    superModule: baseMyHelper

})); // module.__proto__.superModule can also be used but lint doesn't like it (see no-proto rule)

var bonusUnitPriceModel = Proxy('../../../../../../social_checkout/cartridges/int_google_tempbasket_addon/cartridge/models/product/decorators/bonusUnitPrice.js', {
    'dw/order/BasketMgr': BasketMgr,
    '*/cartridge/scripts/util/collections': {
        find: function(){ return {
            getBonusProductPrice: function(apiProduct) {
                return {
                    toFormattedString: function() {
                        return "2"
                    }
                }
            }
        }; }
    }
});

Object.__proto__.concat = function () { return false; }
global.__proto__.in ={}

describe('Bonus Unit Price for Google', function () {
    beforeEach(() => {
        global.request = {
            session:{
                    privacy: ['tempSocialBasket'],
                    tempSocialBasket: ['tempSocialBasket']
                }
            
        };
    });
    it('It should returns the price of the bonus product', function () {
        var result = bonusUnitPriceModel.bonusUnitPrice({}, {},'0000000000000001');
        assert.isUndefined(result);

    });
});