'use strict';

module.exports = class Basket {
    constructor() {
        this.firstName = '';
        this.lastName = '';
        this.address1 = '';
        this.address2 = '';
        this.city = '';
        this.postalCode = '';
        this.countryCode = { value: '' };
        this.phone = '';
        this.billingAddress = {
            firstName: 'Tom', 
            lastName: 'Strong'
        }
    }
    priceAdjustments = {
        iterator: function () {
            var iteratorLoop = false;
            return {
                hasNext() {
                    if (!iteratorLoop) {
                        return true;
                    } else {
                        return false;
                    }
                },
                next: function(){
                    iteratorLoop = true;

                    return {
                        defaultValue: 1000,
                        priceAdjustment: 1000,
                        getPromotionID: function() {
                            return {
                                equalsIgnoreCase: function() {
                                    return false;
                                }
                            }
                        }
                    }
                }
            };
        }        
    }
    custom = {
        productExternalTaxes: JSON.stringify([
            {
                itemId: 'lorem'
            }
        ]),
        socialChannel: 'socialChannel'
    }
    productLineItems = [
        {
            UUID: 'lorem',
            adjustedNetPrice: 0,
            tax: 20,
            priceAdjustments: [{
                setTaxClassID: function () {
                    return;
                },
                updateTax: function () {
                    testExternalTaxesHelpers.testEnd = 1;
                    return;
                }
            }],
            shippingLineItem: [{
                setTaxClassID: function () {
                    return;
                },
                updateTax: function () {
                    testExternalTaxesHelpers.testEnd = 1;
                    return;
                }
            }],
            shippingPriceAdjustments: [{
                setTaxClassID: function () {
                    return;
                },
                updateTax: function () {
                    testExternalTaxesHelpers.testEnd = 1;
                    return;
                }
            }],
            setTaxClassID: function () {
                return;
            },
            updateTax: function () {
                testExternalTaxesHelpers.testEnd = 1;
                return;
            },
            setTax: function () {
                return;
            },
            updateTaxAmount: function () {
                return;
            },
            custom: {
                externalTax: ''
            }
        }

    ]
    createProductLineItem() {
        return {
            getOptionProductLineItems: function() {
                return {
                    iterator: function() {
                        let i = 0;
                        return {
                            items: [{
                                setPriceValue: function () {
                                    return;
                                },
                                updateTax: function () {
                                    return;
                                }                                              
                            }],
                            hasNext: function() {
                                return i < this.items.length;
                            },
                            next: function() {
                                return this.items[i++];
                            },
                            updateTax: function() {
                                return '10';
                            }
                        }
                    }
                }
            },
            setProductInventoryList: function() {
                return;
            },
            custom: {
                externalLineItemStatus: 0
            },
            setQuantityValue: function () {
                return 1;
            },
            setPriceValue: function() {
                return;
            },
            setTax: function() {
                return;
            },
            updateTax: function() {
                return;
            },
            updateTaxAmount: function() {
                return;
            },
            createPriceAdjustment: function() {
                return {
                    setPriceValue: function() {
                        return;
                    },
                    setTax: function() {
                        return;
                    },
                    updateTax: function() {
                        return;
                    },
                    updateTaxAmount: function() {
                        return;
                    }
                }
            },
            getAdjustedTax: function() {
                return {
                    getValue: function() {
                        return;
                    }
                };
            },
            getAdjustedNetPrice: function() {
                return {
                    getValue: function() {
                        return;
                    }
                };
            }
        }
    }
    removePriceAdjustment() {
        return
    }
    createBillingAddress() {
        return {
            setFirstName: function () { 
                return;
            },
            setLastName: function () { 
                return;
            },
            setAddress1: function () { 
                return;
            },
            setAddress2: function () { 
                return;
            },
            setCity: function () { 
                return;
            },
            setPostalCode: function () { 
                return;
            },
            setStateCode: function () { 
                return;
            },
            setPhone: function () { 
                return;
            },
            setCountryCode: function () { 
                return;
            }
        }
    }
    getCurrencyCode() { 
        return 'USD'; 
    }
    getDefaultShipment() {
        return {
            hadCreateShippingAddress: true,
            createShippingAddress() {
                return {
                    setFirstName: function () { 
                        return;
                    },
                    setLastName: function () { 
                        return;
                    },
                    setAddress1: function () { 
                        return;
                    },
                    setAddress2: function () { 
                        return;
                    },
                    setCity: function () { 
                        return;
                    },
                    setPostalCode: function () { 
                        return;
                    },
                    setStateCode: function () { 
                        return;
                    },
                    setPhone: function () { 
                        return;
                    },
                    setCountryCode: function () { 
                        return
                    }
                };
            }
        }
    }
    getAllProductLineItems() {
        return {
            toArray: function toArray(){
                return {
                    map: function map() {
                        return {
                            join: function join(){ return ""}
                        };
                    }
                }
            }
        }
    }
    setChannelType() {
        return;
    }
}
