import { test, expect, request } from '@playwright/test';
var order;

test.describe('Order gets shipped.', () => {
    test.beforeAll(async ({ request }) => {
        //TSOB Token
        const accessToken = await request.post(`https://${process.env.BM_SHORT_CODE}.api.commercecloud.salesforce.com/shopper/auth/v1/organizations/${process.env.BM_ORGANIZATION_ID}/oauth2/trusted-system/token`, {
            headers: {
                "Content-Type": "application/x-www-form-urlencoded",
                'Authorization': `Basic ${Buffer.from(process.env.SLAS_CLIENTID + ':' + process.env.SLAS_CLIENTSECRET).toString("base64")}`
            },
            form: {
                "grant_type": "client_credentials",
                "hint": "ts_ext_on_behalf_of",
                "login_id": process.env.INSTAGRAM_EMAIL,
                "idp_origin": process.env.SOCIAL_CHANNEL,
                "channel_id": process.env.BM_SITE
            }
        });

        const test = await accessToken.text();

        expect(accessToken.ok()).toBeTruthy();

        const response = await accessToken.json();

        process.env.ACCESS_TOKEN = response.access_token;
    });

    test('Scenario 2 - Creates an order, updates the status (OMS modification simulation), returns the updated order and status OK', async ({ request }) => {
          await test.step('Can create an order on-the-fly in the Commerce Cloud platform', async () => {
            let response = await request.post(`https://${process.env.BM_SHORT_CODE}.api.commercecloud.salesforce.com/checkout/orders/v1/organizations/${process.env.BM_ORGANIZATION_ID}/orders?siteId=${process.env.BM_SITE}`, {
                headers: {
                    "Content-Type": "application/json",
                    "Authorization": `Bearer ${process.env.ACCESS_TOKEN}`
                },
                data: JSON.stringify({
                    "billingAddress": {
                    "address1": "43 Main Rd.",
                    "city": "Burlington",
                    "firstName": "Vitoria Carolina",
                    "lastName": "Santos"
                  },
                  "channelType": "instagramcommerce",
                  "currency": "USD",
                  "orderTotal": 355.39,
                  "taxTotal": 44.78,
                "c_buyerNote": "note from buyer",
                "c_orderNote": "note for the order",
                "c_orderTag": "Tag for the order",
                  "paymentInstruments": [
                    {
                      "paymentMethodId": "PAYPAL",
                      "paymentTransaction": {
                        "amount": 303.95,
                        "transactionId": "abc13384ajsgdk1"
                      }
                    }
                  ],
                  "productItems": [
                    {
                      "basePrice": 299.00,
                      "grossPrice": 299.00,
                      "netPrice": 299.00,
                      "productId": "609717696966M",
                      "productName": "5 Pocket Cuffed Capri (Plus)",
                      "quantity": 2,
                      "shipmentId": "shipment1",
                      "tax": 12.39
                    },
                    {
                      "basePrice": 24.00,
                      "grossPrice": 24.00,
                      "netPrice": 24.00,
                      "productId": "701642923466M",
                      "productName": "3/4 Sleeve V-Neck Top",
                      "quantity": 1,
                      "shipmentId": "shipment1",
                      "tax": 10.00
                    }
                  ],
                  "shipments": [
                    {
                      "shipmentId": "shipment1",
                      "shippingAddress": {
                        "address1": "43 Main Rd.",
                        "city": "Burlington",
                        "firstName": "Vitoria Carolina",
                        "lastName": "Santos"
                      },
                      "shippingMethod": "001",
                      "shippingTotal": 10.00,
                      "taxTotal": 22.39
                    }
                  ]
                })
            });

            expect(response.ok()).toBeTruthy();
            order = await response.headersArray()[3].value;
            
          });
         await test.step('Order PATCH to update shipping status', async () => {
            let responseSOM = await request.patch(`${process.env.BM_URL}/s/RefArch/dw/shop/v21_3/${order}?client_id=${process.env.OCAPI_CLIENTID}`, {
                headers: {
                    "Content-Type": "application/json",
                    "Authorization": `Bearer ${process.env.ACCESS_TOKEN}`
                },
                data: JSON.stringify({
                  "c_orderAction": "update",
                  "c_externalChannelOrderStatus": 5,
                  "c_externalReturnStatus": 7,
                  "shipping_status": "shipped"
              })
            });

            expect(responseSOM.ok()).toBeTruthy();
        });
    });
});
