import { test, expect, chromium, type Page } from '@playwright/test';

async function createGoogleCartPermalink(pidsQtdMock) {
    var regex = new RegExp('^([a-zA-Z0-9\\-\\_]+\\:\\d+)(?:\\,[a-zA-Z0-9\\-\\_]+\\:\\d+)*$', 'g');

    var pipeline = String(process.env.BM_URL) + '/on/demandware.store/Sites-' + process.env.BM_SITE + '-Site/default/Google-Cart/';

    if (regex.test(pidsQtdMock)) {
        var pipeline = String(process.env.BM_URL) + '/on/demandware.store/Sites-' + process.env.BM_SITE + '-Site/default/Google-Cart/';
        pipeline = pipeline.concat(pidsQtdMock, '?checkout=false').toString();
    }

    return decodeURIComponent(pipeline).toString();
}

test.describe('Checkout by google cart link', () => {
    var googleCartPermalink;
    var expirationYear = new Date().getFullYear() + 1;
    
    test('Create a cart link for a product', async () => {
        googleCartPermalink = await createGoogleCartPermalink(process.env.PRODUCT_IDS_QTD_MOCK);
        await expect(googleCartPermalink).not.toEqual(null);
    });

    test('Redirect to cart', async () => {
        const browser = await chromium.launch();
        const page = await browser.newPage();
        await page.goto(String(googleCartPermalink));
        await expect(page).toHaveURL(/.*\/Cart/);
    });

    test('Complete a checkout', async () => {
        const browser = await chromium.launch();
        const page = await browser.newPage();
        await page.goto(String(googleCartPermalink));
        await page.getByRole('button', { name: 'Yes' }).click();
        await page.getByRole('button', { name: 'Checkout' }).click();
        await page.locator('#email-guest').click();
        await page.locator('#email-guest').fill('joedoe@test.com');
        await page.getByRole('button', { name: 'Continue as guest' }).click();
        await page.getByRole('textbox', { name: '* First Name' }).click();
        await page.getByRole('textbox', { name: '* First Name' }).fill('Joe');
        await page.getByRole('textbox', { name: '* Last Name' }).click();
        await page.getByRole('textbox', { name: '* Last Name' }).fill('Doe');
        await page.getByRole('textbox', { name: '* Address 1' }).click();
        await page.getByRole('textbox', { name: '* Address 1' }).fill('Street 1');
        await page.locator('#shippingCountrydefault').selectOption('US');
        await page.locator('#shippingStatedefault').selectOption('CA');
        await page.getByRole('textbox', { name: '* City' }).click();
        await page.getByRole('textbox', { name: '* City' }).fill('San Francisco');
        await page.getByRole('textbox', { name: '* ZIP Code' }).click();
        await page.getByRole('textbox', { name: '* ZIP Code' }).fill('12345');
        await page.getByRole('textbox', { name: '* Phone Number' }).click();
        await page.getByRole('textbox', { name: '* Phone Number' }).fill('9234567890');
        await page.getByRole('button', { name: 'Next: Payment' }).click();
        await page.getByLabel('Card Number').click();
        await page.getByLabel('Card Number').fill('4111 1111 1111 1111');
        await page.getByLabel('Expiration Month').selectOption('12');
        await page.getByLabel('Expiration Year').selectOption(String(expirationYear));
        await page.getByLabel('Security Code').click();
        await page.getByLabel('Security Code').fill('123');
        await page.getByRole('button', { name: 'Next: Place Order' }).click();
        await page.locator('.place-order').click();
        await expect(page).toHaveURL(/.*\/Order-Confirm/);
    });
});
