@IsTest(SeeAllData=true) 
//Required due to the ConnectApi call, following the documentation guidance: https://developer.salesforce.com/docs/atlas.en-us.apexcode.meta/apexcode/connectAPI_TestingApex.htm
public class AppeasementTest {

    private static final SocialMockGenerator socialMockGenerator = new SocialMockGenerator();

    @IsTest
    public static void testAppeasementOrder() {
        account newAccount = socialMockGenerator.generateAccount('Coffe Account');
        Product2 newProduct = socialMockGenerator.generateProduct('Coffe Machine',  '123456');
        Pricebook2 newPricebook = socialMockGenerator.generatePricebook('Coffe Machine Pricebook', true);
        PricebookEntry[] newPricebookEntry = socialMockGenerator.generatePricebookEntry(newProduct, newPricebook, 50, 50, true);
        Order newOrder = socialMockGenerator.generateOrder('draft', newAccount, newPricebook);
        OrderDeliveryMethod newOrderDeliveryMethod = socialMockGenerator.generateOrderDeliveryMethod('Test ODM', true, '12342', newProduct);
        OrderDeliveryGroup newOrderDeliveryGroup = socialMockGenerator.generateOrderDeliveryGroup(newOrder, 'Coffe Delivery', newOrderDeliveryMethod);
        OrderItem newOrderItem = socialMockGenerator.generateOrderItem(newOrder, newProduct, newPricebookEntry, 1, 10, newOrderDeliveryGroup, 'Order Product');
        
        socialMockGenerator.updateOrderStatus(newOrder, 'Activated');
        String orderSummaryId = socialMockGenerator.generateOrderSummary(newOrder, 'MANAGED');
        String itemSummaryId = [SELECT Id FROM OrderItemSummary WHERE OrderSummaryId =: orderSummaryId AND Product2Id =: newProduct.Id LIMIT 1].Id;

        List<ConnectApi.OrderItemSummaryInputRepresentation> orderItemSummaryInputRepresentationList = new List<ConnectApi.OrderItemSummaryInputRepresentation>();
        ConnectApi.OrderItemSummaryInputRepresentation orderItemSummaryInputRepresentation = socialMockGenerator.generateOrderItemSummaryInputRepresentation(itemSummaryId, 1);
        orderItemSummaryInputRepresentationList.add(orderItemSummaryInputRepresentation);
        socialMockGenerator.generateFullfilmentOrder(orderSummaryId, newOrderDeliveryGroup.Id, orderItemSummaryInputRepresentationList);

        FulfillmentOrder fulfillmentOrder = [SELECT Status FROM FulfillmentOrder WHERE OrderSummaryId=: orderSummaryId LIMIT 1];
        fulfillmentOrder.Status = 'Fulfilled';
        update fulfillmentOrder;

        ConnectApi.AdjustOrderItemSummaryInputRepresentation adjustInput = new ConnectApi.AdjustOrderItemSummaryInputRepresentation();
        List<ConnectApi.AdjustItemInputRepresentation> adjustItemInputRepresentationList = new List<ConnectApi.AdjustItemInputRepresentation>();
            ConnectApi.AdjustItemInputRepresentation adjustItemInputRepresentation = new ConnectApi.AdjustItemInputRepresentation();
                AdjustItemInputRepresentation.adjustmentType = 'AmountWithTax';
                AdjustItemInputRepresentation.amount = -10;
                AdjustItemInputRepresentation.description = 'Refund as Appeasement';
                AdjustItemInputRepresentation.orderItemSummaryId = itemSummaryId;
                AdjustItemInputRepresentation.reason = 'Unknown';
            adjustItemInputRepresentationList.add(adjustItemInputRepresentation);
        adjustInput.adjustItems = adjustItemInputRepresentationList;
        adjustInput.allocatedItemsChangeOrderType = 'InFulfillment';
        adjustInput.individualLineItemTaxAdjustments = false;

        ConnectApi.AdjustOrderSummaryOutputRepresentation adjustOrderSummaryOutputRepresentation = ConnectApi.OrderSummary.adjustSubmit(orderSummaryId, adjustInput);

        List<String> orderSummaryIds = new List<String>();
        orderSummaryIds.add(orderSummaryId);
        ExportOrderSummaryItem exportOrderSummaryItem = new ExportOrderSummaryItem();

        Test.startTest();
        Test.setMock(HttpCalloutMock.class, new OrderExportMockGenerator());
        
        exportOrderSummaryItem.processData(orderSummaryIds);
        
        Test.stopTest();
    }
}