'use strict';

/* eslint-disable no-unused-vars */

/* API Includes */
var Logger = require('dw/system/Logger').getLogger('ocapi-hooks', 'basket');
var Status = require('dw/system/Status');

var socialCheckoutHelpers = require('*/cartridge/scripts/util/socialCheckoutHelpers');
var externalTaxesHelpers = require('*/cartridge/scripts/util/externalTaxesHelpers');

exports.afterPATCH = function (basket, basketInput) { // eslint-disable-line consistent-return
    Logger.debug('dw.ocapi.shop.basket.afterPATCH');
    // Applying the new tax value to each productLineItem in the basket
    try {
        externalTaxesHelpers.updateExternalTaxesProductLineItems(basket);
    } catch (e) {
        return new Status(Status.ERROR, 'ERROR', e.message);
    }

    try {
        var channelType = socialCheckoutHelpers.getChannelType(basketInput.channel_type || null);

        // if channelType can be parsed, save a copy of channel_type on the new custom attribute
        if (!empty(channelType)) {
            const Transaction = require('dw/system/Transaction');

            Transaction.wrap(function () {
                basket.custom.customChannelType = basketInput.channel_type;
                basket.custom.socialChannel = basketInput.channel_type;
            });

            basket.setChannelType(channelType);
        }
    } catch (e) {
        return new Status(Status.ERROR, 'ERROR', e.toString() + ' in ' + e.fileName + ':' + e.lineNumber);
    }
    // a non-null Status ends the hook execution, do not return status if everything is OK
};

exports.afterPOST = function (basket) { // eslint-disable-line consistent-return
    Logger.debug('dw.ocapi.shop.basket.afterPOST');
    try {
        var channelType = Object.hasOwnProperty.call(basket.custom, 'socialChannel') && basket.custom.socialChannel ? socialCheckoutHelpers.getChannelType(basket.custom.socialChannel) : null;

        // if channelType can be parsed, save a copy of socialChannel on the new custom attribute
        if (!empty(channelType)) {
            const Transaction = require('dw/system/Transaction');

            Transaction.wrap(function () {
                basket.custom.customChannelType = basket.custom.socialChannel;
            });

            basket.setChannelType(channelType);
        }
    } catch (e) {
        return new Status(Status.ERROR, 'ERROR', e.toString() + ' in ' + e.fileName + ':' + e.lineNumber);
    }
    // a non-null Status ends the hook execution, do not return status if everything is OK
};

// All three hooks call me:
// dw.ocapi.shop.basket.modifyPOSTResponse
// dw.ocapi.shop.basket.coupon.modifyPOSTResponse
// dw.ocapi.shop.basket.items.modifyPOSTResponse
exports.modifyPOSTResponse = function (basket, basketResponse, _) {
    basketResponse.productItems = socialCheckoutHelpers.setPriceAdjustmentsAppliedDiscountQuantity(basket, basketResponse);
};

exports.modifyDELETEResponse = function (basket, basketResponse, couponItemId) {
    basketResponse.productItems = socialCheckoutHelpers.setPriceAdjustmentsAppliedDiscountQuantity(basket, basketResponse);
};

exports.modifyPATCHResponse = function (basket, basketResponse, productItemId) {
    basketResponse.productItems = socialCheckoutHelpers.setPriceAdjustmentsAppliedDiscountQuantity(basket, basketResponse);
};

// All two hooks call me:
// dw.ocapi.shop.basket.shipment.shipping_address.modifyPUTResponse
// dw.ocapi.shop.basket.shipment.shipping_method.modifyPUTResponse
exports.modifyPUTResponse = function (basket, basketResponse, _) {
    basketResponse.productItems = socialCheckoutHelpers.setPriceAdjustmentsAppliedDiscountQuantity(basket, basketResponse);
};
