'use strict';

/**
 * SOM Services Manager
 */

var LocalServiceRegistry = require('dw/svc/LocalServiceRegistry');
var rest = require('~/cartridge/scripts/services/somServiceDefinitions');

var somPreferences = require('~/cartridge/config/somPreferences');
var SOM_SERVICE_ID = somPreferences.somServiceID;

/**
 * Returns the service related to the given {serviceID} initialized with the given {definition}
 * @param {string} serviceID - service id
 * @param {Object} definition - definition object
 *
 * @returns {dw/svc/Service} service instance
 */
function getService(serviceID, definition) {
    if (request.httpHeaders.mockomsrequest) {
        return LocalServiceRegistry.createService('MockService', {
            mockCall: function (svc) {
                var responseMocked = request.httpHeaders.jsonomsmockresponseordersummariesfirstcall;
                if (session.custom.calls >= 1) {
                    responseMocked = request.httpHeaders.jsonomsmockresponseordersummariessecondcall;
                    delete session.custom.calls;
                }
                if (svc.requestData && svc.requestData[0].indexOf('changeItems') >= 0) {
                    responseMocked = request.httpHeaders.jsonomsmockresponsechangeitems;
                }

                session.custom.calls = session.custom.calls ? session.custom.calls + 1 : 1;

                return {
                    statusCode: 200,
                    statusMessage: 'success',
                    text: responseMocked
                };
            },
            parseResponse: function (svc, client) {
                return {
                    isValidJSON: true,
                    isError: false,
                    responseObj: JSON.parse(client.text),
                    errorText: ''
                };
            }
        });
    }

    return LocalServiceRegistry.createService(serviceID, definition);
}

module.exports = {
    restEndpoints: rest.endpoints,

    /**
     * Returns a new instance of the SOM REST Service initialized with the {composite} definitions
     * @returns {dw/svc/Service} service instance
     */
    restComposite: function () {
        return getService(SOM_SERVICE_ID, rest.definitions.composite);
    },
    restApi: function (url) {
        return getService(SOM_SERVICE_ID, rest.definitions.api(url));
    }
};
