'use strict';

var Address = require('~/cartridge/models/somAddress');
/**
 * Create a SOM shipping model
 * @constructor
 * @classdesc class that represents a shipping object
 *
 * @param {Object} somApiOrderSummary - OrderSummaryObject from SOM API in JSON format
 */
function SomShipping(somApiOrderSummary) {
    this.deliverToAddress = '-';
    this.deliverToName = '-';
    this.deliveryMethodName = '-';
    this.totalQuantity = 0;
    this.deliveryCharge = {};
    if (somApiOrderSummary && somApiOrderSummary.OrderDeliveryGroupSummaries) {
        this.deliveryMethodName = somApiOrderSummary.DeliveryMethod.Name;
        this.deliveryMethodDescription = somApiOrderSummary.DeliveryMethod.Description;
        this.deliverToName = somApiOrderSummary.OrderDeliveryGroupSummaries.records[0].DeliverToName;
        this.deliverToAddress = new Address(somApiOrderSummary.OrderDeliveryGroupSummaries.records[0].DeliverToAddress);

        var otherOrderItems = somApiOrderSummary.OrderItemGrouped.Other;
        if (otherOrderItems) {
            var otherOrderItemIdIdx = otherOrderItems.map(function (otherOrderItem) { return otherOrderItem.Type; }).indexOf(String('Delivery Charge'));
            var deliveryChargeItem = otherOrderItemIdIdx === -1 ? null : otherOrderItems[otherOrderItemIdIdx];

            if (deliveryChargeItem) {
                this.deliveryCharge = {
                    orderItemSummaryId: deliveryChargeItem.Id,
                    productCode: deliveryChargeItem.ProductCode,
                    type: deliveryChargeItem.Type,
                    totalPrice: deliveryChargeItem.TotalPrice,
                    totalTaxAmount: deliveryChargeItem.TotalTaxAmount
                };
            }
        }
    }
}
module.exports = SomShipping;
