'use strict';

var linkHelpers = module.superModule;

/**
 * Generate the URL Google perm link based on basket product line items
 * @param {dw.order} basket The Basket class represents a shopping cart.
 * @param {boolean} checkout if true redirect to checkout page
 * @returns {Object} Google perm link URL
 */
function generateGooglePermLinks(basket, checkout) {
    var URLUtils = require('dw/web/URLUtils');

    if (basket) {
        var actions = basket.getAllProductLineItems().toArray().map(function (productLineItem) {
            return String.concat(productLineItem.productID, ':', productLineItem.quantityValue);
        });

        if (!empty(actions)) {
            return {
                relative: String.concat(URLUtils.https('Google-Cart').relative().toString(), '/', actions.join(','), '?checkout=', checkout),
                absolute: String.concat(URLUtils.https('Google-Cart').abs().toString(), '/', actions.join(','), '?checkout=', checkout)
            };
        }
    }

    return null;
}

linkHelpers.generateGooglePermLinks = generateGooglePermLinks;

module.exports = linkHelpers;
