'use strict';

/**
 * Get a current temporary basket or use the standard basket
 * @param {boolean} currentOrNew Current or create a new standard basket
 * @returns {string} a redirect url
 */
function getCurrentSocialBasket(currentOrNew) {
    var BasketMgr = require('dw/order/BasketMgr');
    var tempSocialBasket = request.session.privacy.tempSocialBasket || null;
    var currentSocialBasket;

    if (currentOrNew) {
        currentSocialBasket = !empty(tempSocialBasket) && !empty(BasketMgr.getTemporaryBasket(tempSocialBasket)) ? BasketMgr.getTemporaryBasket(tempSocialBasket) : BasketMgr.getCurrentOrNewBasket();
    } else {
        currentSocialBasket = !empty(tempSocialBasket) && !empty(BasketMgr.getTemporaryBasket(tempSocialBasket)) ? BasketMgr.getTemporaryBasket(tempSocialBasket) : BasketMgr.getCurrentBasket();
    }

    return currentSocialBasket;
}

module.exports = {
    getCurrentSocialBasket: getCurrentSocialBasket
};
