'use strict';

var BasketMgr = require('dw/order/BasketMgr');
var collections = require('*/cartridge/scripts/util/collections');

var bonusUnitPriceModel = module.superModule;

/**
 * returns the price of the bonus product
 * @param {dw.catalog.Product} apiProduct - Product information returned by the script API
 * @param {string} duuid - discount line item UUID
 * @returns {string} - returns the price of the bonus product
 */
function getBonusUnitPrice(apiProduct, duuid) {
    var tempSocialBasket = 'tempSocialBasket' in request.session.privacy && !empty(request.session.privacy.tempSocialBasket) ? request.session.privacy.tempSocialBasket : null;

    var currentBasket = !empty(tempSocialBasket) && !empty(BasketMgr.getTemporaryBasket(tempSocialBasket)) ? BasketMgr.getTemporaryBasket(tempSocialBasket) : BasketMgr.getCurrentBasket();

    var bonusDisconutLineItem = collections.find(currentBasket.getBonusDiscountLineItems(), function (dli) {
        return dli.UUID === duuid;
    });

    if (!apiProduct || !bonusDisconutLineItem) {
        return '';
    }

    return bonusDisconutLineItem.getBonusProductPrice(apiProduct).toFormattedString();
}

bonusUnitPriceModel.bonusUnitPrice = function (object, apiProduct, duuid) {
    Object.defineProperty(object, 'bonusUnitPrice', {
        enumerable: true,
        value: getBonusUnitPrice(apiProduct, duuid)
    });
};

module.exports = bonusUnitPriceModel;
