'use strict';

/**
 * Create a list with product ids and quantities
 * @param {string} action string that represent products and quantities in an action
 * @returns {Array} products and quantities list object
 */
function createPidsObj(action) {
    var pidsObj = [];

    var lines = action.split(',');

    for (var i = 0; i < lines.length; i++) {
        var product = lines[i].split(':');
        if (product.length > 1) {
            pidsObj.push({
                pid: product[0],
                qty: parseInt(product[1], 10)
            });
        }
    }

    return pidsObj;
}

/**
 * Validate action string
 * @param {string} action string that represent products and quantities in an action
 * @returns {boolean} valid string
 */
function isAValidActionString(action) {
    // eslint-disable-next-line prefer-regex-literals
    var regex = new RegExp('^([a-zA-Z0-9\\-\\_]+\\:\\d+)(?:\\,[a-zA-Z0-9\\-\\_]+\\:\\d+)*$', 'g');
    return regex.test(action);
}

module.exports = {
    createPidsObj: createPidsObj,
    isAValidActionString: isAValidActionString
};
