'use strict';

const mockedResponses = require('~/cartridge/scripts/tests/data/snapMockedResponses');
const MOCK_SUCCESS = true;

/**
 * set mock text
 * @param {Object} jsonObject - the object to stringify
 * @returns {string} stringified JSON object
 */
function setMockText(jsonObject) {
    if (!jsonObject || !Object.keys(jsonObject).length) return '';
    jsonObject.isMocked = true; // eslint-disable-line no-param-reassign
    return JSON.stringify(jsonObject);
}

var SnapMockService = {
    createFeedUpload: function () {
        if (MOCK_SUCCESS) {
            return {
                statusCode: 200,
                statusMessage: 'OK',
                text: setMockText(mockedResponses.createFeedUpload.success)
            };
        }
        return {
            statusCode: 400,
            statusMessage: 'ERROR',
            errorText: setMockText(mockedResponses.createFeedUpload.error)
        };
    },
    getAdAccounts: function () {
        if (MOCK_SUCCESS) {
            return {
                statusCode: 200,
                statusMessage: 'OK',
                text: setMockText(mockedResponses.getAdAccounts.success)
            };
        }
        return {
            statusCode: 400,
            statusMessage: 'ERROR',
            errorText: setMockText(mockedResponses.getAdAccounts.error)
        };
    },
    getCatalogs: function () {
        if (MOCK_SUCCESS) {
            return {
                statusCode: 200,
                statusMessage: 'OK',
                text: setMockText(mockedResponses.getCatalogs.success)
            };
        }
        return {
            statusCode: 400,
            statusMessage: 'ERROR',
            errorText: setMockText(mockedResponses.getCatalogs.error)
        };
    },
    getFeedUpload: function () {
        if (MOCK_SUCCESS) {
            return {
                statusCode: 200,
                statusMessage: 'OK',
                text: setMockText(mockedResponses.getFeedUpload.success)
            };
        }
        return {
            statusCode: 400,
            statusMessage: 'ERROR',
            errorText: setMockText(mockedResponses.getFeedUpload.error)
        };
    },
    getOrgList: function () {
        if (MOCK_SUCCESS) {
            return {
                statusCode: 200,
                statusMessage: 'OK',
                text: setMockText(mockedResponses.getOrgList.success)
            };
        }
        return {
            statusCode: 400,
            statusMessage: 'ERROR',
            errorText: setMockText(mockedResponses.getOrgList.error)
        };
    }
};

module.exports = SnapMockService;
