'use strict';

var VERSION = 'v1';
var GET_ORG = '/' + VERSION + '/organizations/{0}';
var GET_ORG_CATALOGS = GET_ORG + '/catalogs';
var GET_CATALOG = '/' + VERSION + '/catalogs';

module.exports = {
    ACTIONS: {
        DISCONNECT: 'DISCONNECT',
        CREATE_CATALOG: 'CREATE_CATALOG',
        CREATE_PRODUCT_FEED: 'CREATE_PRODUCT_FEED',
        CREATE_FEED_UPLOAD: 'CREATE_FEED_UPLOAD',
        GET_AD_ACCOUNTS: 'GET_AD_ACCOUNTS',
        GET_AUTH_TOKEN: 'GET_AUTH_TOKEN',
        GET_BUSINESS_PROFILE: 'GET_BUSINESS_PROFILE',
        GET_CATALOG: 'GET_CATALOG',
        GET_FEED_UPLOAD: 'GET_FEED_UPLOAD',
        GET_ORG: 'GET_ORG',
        GET_ORG_CATALOGS: 'GET_ORG_CATALOGS',
        GET_ORG_LIST: 'GET_ORG_LIST',
        GET_PRODUCT_FEEDS: 'GET_PRODUCT_FEEDS',
        GET_PIXEL_FROM_AD_ACCOUNT: 'GET_PIXEL_FROM_AD_ACCOUNT',
        GET_REFRESH_TOKEN: 'GET_REFRESH_TOKEN',
        NOTIFY_ORDER: 'NOTIFY_ORDER'
    },
    BUSINESS_PLATFORM: 'SALESFORCE',
    CONTENT_TYPE: {
        JSON: 'application/json',
        URLENCODED: 'application/x-www-form-urlencoded'
    },
    ENDPOINTS: {
        AUTH: '/login/oauth2/access_token',
        AUTHORIZE: '/login/oauth2/authorize',
        CREATE_PRODUCT_FEED: GET_CATALOG + '/{0}/product_feeds',
        CREATE_FEED_UPLOAD: '/' + VERSION + '/product_feeds/{0}/feed_uploads',
        DISCONNECT: '/accounts/oauth2/revoke',
        GET_AD_ACCOUNTS: GET_ORG + '/adaccounts',
        GET_BUSINESS_PROFILE: '/' + VERSION + '/me',
        GET_CATALOG: GET_CATALOG + '/{0}',
        GET_FEED_UPLOAD: '/' + VERSION + '/feed_uploads/{0}',
        GET_ORG: GET_ORG,
        GET_ORG_CATALOGS: GET_ORG_CATALOGS,
        GET_ORG_LIST: '/' + VERSION + '/me/organizations',
        GET_PIXEL_FROM_AD_ACCOUNT: '/' + VERSION + '/adaccounts/{0}/pixels',
        NOTIFY_ORDER: '/order-webhook/salesforce/order',
        OAUTH_REDIRECT_URL: 'https://snapchat-payments-portal.uc.r.appspot.com/v1/salesforce/redirect_callback',
        OAUTH_URL: 'https://accounts.snapchat.com/login/oauth2/authorize',
        REFRESH: '/login/oauth2/access_token'
    },
    ERROR_CODES: {
        MULTIPLE_ORGS: 'multiple.organizations'
    },
    FEEDS: {
        SOURCE: 'SALESFORCE',
        CATALOG: {
            NATIVE_CHECKOUT_ELIGIBILITY: 'ELIGIBLE',
            VERTICAL: 'COMMERCE'
        },
        PRODUCT: {
            STATUS: 'ACTIVE'
        }
    },
    FEED_PATHS: {
        PRODUCT: '/src/feeds/export/social/snapchat/product'
    },
    FEED_UPLOAD_STATUS: {
        INITIALIZED: 'INITIALIZED',
        FETCHING: 'FETCHING',
        PROCESSING: 'PROCESSING',
        COMPLETE: 'COMPLETE',
        ERRORED: 'ERRORED'
    },
    FEED_UPDATE_TYPES: {
        DELTA: 'delta',
        FULL: 'full',
        DELETE: 'delete'
    },
    IMPEX_DEFAULT_PATH: '/on/demandware.servlet/webdav/Sites/Impex',
    LIMITS: {
        DEFAULT: 200,
        GET_ORG_CATALOGS: 200
    },
    MAX_TRACKING_EVENTS: 300000,
    SERVICES: {
        SNAPCHAT_ACCOUNTS: 'snapchat.rest.accounts',
        SNAPCHAT_ADS: 'snapchat.rest.ads',
        SNAPCHAT_NOTIFY: 'snapchat.rest.notify'
    },
    SNAPCHAT_CUSTOM_OBJECT_ID: 'snapchat-settings',
    SOCIAL_CHANNEL_CUSTOM_OBJECT_DEFINITION: 'SocialChannels'
};
