# TikTok Social Integration

## Table of Contents

<details open><summary>Click to open/close</summary>

- <details><summary>TikTok Shop Installation Video</summary>

    - [TikTok Shop Installation Video](#tiktok-shop-installation-video)

- <details><summary>TikTok Marketing Integration</summary>

    - [Overview](#tiktok-marketing-overview)
    - [Integration Overview](#tiktok-marketing-integration-overview)
    - [Integration Features](#tiktok-marketing-integration-features)
    - [Prerequisites](#tiktok-marketing-prerequisites)
    - [Installation Instructions](#tiktok-marketing-installation-instructions)
        - [Install Dependencies](#install-dependencies)
        - [Upload Cartridges](#upload-tiktok-marketing-cartridges)
        - [Update Cartridge Paths](#update-tiktok-marketing-cartridge-paths)
        - [Import Data](#import-tiktok-marketing-data)
        - [Update Site Preferences](#update-tiktok-marketing-site-preferences)
        - [Assign Business Manager Permissions](#assign-tiktok-marketing-business-manager-permissions)
        - [Configure WebDAV Permissions](#configure-webdav-permissions)
    - [Configure TikTok Marketing Integration](#configure-tiktok-marketing-integration)
    - [Sync Product Catalog and Inventory](#sync-product-catalog-and-inventory)
        - [Review Catalog Feed Configuration](#review-catalog-feed-configuration)
        - [Review Job Configuration](#review-job-configuration)
            - [Export Full Feeds](#export-full-feeds)
            - [Export Delta Feeds](#export-delta-feeds)
- <details><summary>TikTok Pixel</summary>

    - [TikTok Pixel](#tiktok-pixel---sync-shopper-activities-and-monitor-web-events)
      - [Option 1 - Server-based Tracking](#option-1---server-based-tracking)
      - [Option 2 - Browser-based Tracking](#option-2---browser-based-tracking)
- <details><summary>TikTok Shop / Checkout</summary>

    - [Overview](#tiktok-shop-overview)
    - [Integration Overview](#tiktok-shop-integration-overview)
    - [Prerequisites](#tiktok-shop-prerequisites)
    - [TikTok Shop Installation Instructions](#tiktok-shop-installation-instructions)
        - [Install Dependencies](#install-dependencies-1)
        - [Upload TikTok Shop Cartridges](#upload-tiktok-shop-cartridges)
        - [Update TikTok Shop Cartridge Paths](#update-tiktok-shop-cartridge-paths)
        - [Import TikTok Shop Data](#import-tiktok-shop-data)
        - [Update TikTok Shop Site Preferences](#update-tiktok-shop-site-preferences)
        - [Assign Business Manager Permissions](#assign-tiktok-shop-business-manager-permissions)
        - [Configure WebDAV Permissions](#configure-webdav-permissions-1)
        - [Configure OCAPI Permissions](#configure-ocapi-permissions)
        - [Configure Pipeline URL Alias](#configure-pipeline-url-alias)
        - [Configure Order Settings](#configure-order-settings)
    - [Configure TikTok Shop Integration](#configure-tiktok-shop-integration)
    - [Sync Product Catalog, Inventory, and Export Orders Status](#sync-product-catalog-inventory-and-export-orders-status)
      - [Review Catalog Feed Configuration](#review-catalog-feed-configuration)
      - [Review Job Configuration](#review-job-configuration)
        - [Export Full Feeds](#export-full-feeds)
        - [Export Delta Feeds](#export-delta-feeds)
        - [Export Order Status](#export-order-status)
    - [Order Management Integration](#order-management-system-oms-integration)
    - [Omnichannel Inventory Integration](#omnichannel-inventory-oci-integration)
- <details><summary>Global Installation Instructions</summary>

    - [Import TikTok Global Data](#import-tiktok-global-data)
        - [Option 1: Via npm scripts using sfcc-ci](#option-1-via-npm-scripts-using-sfcc-ci)
        - [Option 2: Manually Zip, Upload, and Import via Business Manager](#option-2-manually-zip-upload-and-import-via-business-manager)
    - [Import TikTok Site Data](#import-tiktok-site-data)
    - [TikTok Onboarding Configuration Table](#tiktok-onboarding-configuration-table)
        - [Salesforce B2C Commerce Onboarding Details](#salesforce-b2c-commerce-onboarding-details)
        - [TikTok Onboarding Details](#tiktok-onboarding-details)
    - [TikTok Changes](#tiktok-changes)
</details>
</details>
</details>
</details>
</details>
</details>

## TikTok Shop Installation Video
[![TikTok Shop Installation Video](../docs/images/tiktok-install-slide.jpg)](https://salesforce.vidyard.com/watch/9imcQvd85JvsGjctgt5gym)

## [TikTok Marketing Integration](../social_channels)

### TikTok Marketing Overview

The TikTok Marketing integration is a turnkey solution that enables Salesforce Commerce Cloud merchants to centralize product catalog synchronization and optimize audience engagement in front of over 1 billion global users. Merchants can install and activate the most advanced TikTok pixel (or connect their existing one) to capture Shopper Activities and optimize campaigns towards high-value customer actions.

The TikTok Marketing integration is key to powering current and upcoming Social Commerce features built on product discovery.

### TikTok Marketing Integration Overview
TikTok for Business is a module inside the [Social Channels Extension](../social_channels), built from a set of business manager cartridges, that enables commerce cloud merchandisers to improve product discoverability of products and increase traffic into commerce cloud storefronts. This integration for Ads enables commerce cloud customers to:

1. Launch TikTok for Ads experience from within SFCC Business Manager
2. Publish an entire site catalog (and product updates/deletion) into TikTok
3. Install and connect a new (or existing) TikTok pixel to send key Shopper Activities from their storefront into TikTok

### TikTok Marketing Integration Features
The TikTok Marketing integration on Salesforce Commerce Cloud lets you:

- **Get started with TikTok For Business.** With a click of a button, you can create or link your TikTok For Business account, TikTok Ads Manager and TikTok Business Center, and sync your product catalog.
- **Sync your e-commerce catalog**. Make your products discoverable on TikTok with the automatic catalog sync from Salesforce. Seamlessly manage catalog updates from Salesforce Commerce Cloud and apply catalog refreshes as frequently as every 15 minutes - no additional steps needed.
- **Unlock advanced Pixel features.** The integration will pre-populate a new advanced TikTok pixel, built using the powerful developer codebase. Follow [these steps](https://ads.tiktok.com/help/article?aid=10010829) to complete pixel installation on your site, and gain access to:
    - **Advanced Matching:** Track website visitor events with improved match rate accuracy to better measure results.
    - **Audience enrichment:** Build audiences and capitalize on opportunities to show relevant ads to potential customers.
    - **Product parameters:** Send additional information about website visitor actions, like the total price of an order or product name and category. You can use these product parameters to enrich reporting with metrics like Return on Ad Spend (ROAS) and optimize delivery towards high value users.
      > You can also connect an existing TikTok Pixel following [these steps](https://ads.tiktok.com/help/article?aid=10010829)
- **Promote Products on TikTok**: Easily set up and manage conversion campaigns from A-to-Z within Salesforce Commerce Cloud with our guided campaign creation.

### TikTok Marketing Prerequisites
To integrate with TikTok, please complete the following prerequisites:

1. Ensure you have met the required [SFCC Prerequisites](../README.md#prerequisites)
2. Create a [TikTok User Account](https://www.tiktok.com/signup)
3. Optional: Create a [TikTok Business User](https://www.tiktok.com/business/en/solutions/business-account)
   - This step is optional because you can create your TikTok business account during the on-boarding process

### TikTok Marketing Installation Instructions

#### Install Dependencies
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Follow the steps from [Install Dependencies and Create dw.json](../README.md#install-dependencies-and-create-dwjson)

#### Upload TikTok Marketing Cartridges
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

- `int_social_base`: This cartridge contains code shared by all the social channels. It should be applied to both the storefront and Business Manager cartridge paths.
- `bm_socialchannels`: This cartridge contains the Business Manager controllers/UI logic to provide a new Business Manager extension that the site admin can use to integrate with TikTok.
- `int_tiktok`: This cartridge contains the logic to integrate with TikTok. It contains the service definitions, logic to handle the customer object that stores the TikTok details, and the job which syncs the B2C Commerce product catalog with TikTok.
- `bc_library`: This library contains all shared code for various demandware community projects. Ported from [demandware-library](https://github.com/SalesforceCommerceCloud/demandware-library)
- `bm_socialfeeds`: The custom feeds Business Manager module allows merchants to easily create catalog feeds according to their needs. The framework uses a powerful generic export model which ensures reasonable performance while more feeds are added. The extension comes with a BM UI which is easily usable and does not require any technical background.
- `int_socialfeeds`: The custom feeds module allows merchants to easily create catalog feeds according to their needs. The framework uses a powerful generic export model which ensures reasonable performance while more and more feeds are added.

> **NOTE**: In order to upload cartridges via npm scripts, you will need to replicate the dw.json in the `social_channels`, `social_checkout`, and `social_feeds` directories. The npm scripts will attempt to create a symlink, but it might be necessary for you to manually create this symlink for your operating system.

1. From the root of the repo (`social_channel_integrations`), run: `npm run code:upload:tiktok:ads` to upload the `bm_socialchannels`, `int_tiktok`, `bc_library`, `bm_socialfeeds`, `int_socialfeeds` cartridges to your instance. Alternatively, manually upload the cartridge using the instructions below:
    - [Uploading SFCC Cartridges](../README.md#uploading-sfcc-cartridges)

#### Update TikTok Marketing Cartridge Paths
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

To update your **Business Manager** cartridge path:
1. Log in to Business Manager
2. Go to **Administration** > **Sites** > **Manage Sites**
3. Under **Business Manager Site**, click the `Manage the Business Manager site` link.
4. Click the **Settings** tab
5. In the Cartridges field, add the new cartridges listed below. Example path: `int_socialfeeds:bm_socialfeeds:bc_library:bm_socialchannels:int_social_base`
    - int_socialfeeds
    - bm_socialfeeds
    - bc_library
    - bm_socialchannels
    - int_social_base

To update your **Site** cartridge path:
1. Log in to Business Manager
2. Go to **Administration** > **Sites** > **Manage Sites**
3. Select the site that you want to use. Example site identifier: `RefArch`
4. Click the **Settings** tab
5. In the Cartridges field, add the new cartridges listed below. It must be added before the path for app_storefront_base. Example path: `int_tiktok:int_socialfeeds:bc_library:int_social_base:app_storefront_base`
    - int_tiktok
    - int_socialfeeds
    - bc_library
    - int_social_base

#### Import TikTok Marketing Data
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Follow the steps from [Import and Update Configuration Data -> Import Common Data](../README.md#white_check_mark-import-common-data)
2. Follow the steps from [Import TikTok Global Data](#import-tiktok-global-data)

#### Update TikTok Marketing Site Preferences
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Log in to Business Manager
2. Go to **Merchant Tools** > **Site Preferences** > **Custom Site Preference Groups**
3. Click **TikTok**
4. Update **Verify WebDAV Credentials** (tiktokVerifyWebDAV): `Yes` / `true`
5. Update **Verify BM Credentials** (tiktokVerifyBM): `Yes` / `true`
6. Click **Save**
- ![TikTok Marketing Site Preferences](../docs/images/tiktok-site-prefs-ads.png)

#### Assign TikTok Marketing Business Manager Permissions
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Log in to Business Manager
2. Go to **Administration** > **Organization** > **Roles & Permissions**
3. Select the role of your Business Manager user(s)
4. Click the **Business Manager Modules** tab
5. Select the specified Sites under **Sites** (e.g.: RefArch, RefArchGlobal)
6. Click **Apply**
    - ![Select Context - Sites](../docs/images/biz-mngr-select-context-sites.png)
7. Under **Custom Objects**, select the _write_ checkbox for `Custom Object Editor`
    - ![Custom Object Editor](../docs/images/biz-mngr-role-custom-object-editor.png)
8. Under **Social Channels**, select the _write_ checkbox for `TikTok for Business`
    - ![TikTok for Business](../docs/images/biz-mngr-role-tiktok-for-business.png)
9. At the bottom of the screen, Click **Update**
10. At the top of **Business Manager Modules** tab, switch context to **Organization**
11. Click **Apply**
    - ![Select Context - Org](../docs/images/biz-mngr-select-context-org.png)
12. Under **Operations**, select the _write_ checkbox for `Jobs`
13. Under **Operations**, select the _write_ checkbox for `Job History`
    - ![Job Permissions](../docs/images/biz-mngr-role-jobs.png)
14. Under **Social Product Feeds**, select the _write_ checkbox for **Social Product Feeds Definition**
    - ![Social Product Feeds Definition](../docs/images/biz-mngr-role-social-product-feeds-definition.png)
15. At the bottom of the screen, Click **Update**
16. Click the **WebDAV Permissions** tab
17. Scroll to the **Impex** section
18. Click the **Manage custom folders** link
19. In the text box, enter: `src/feeds/export`
    - ![Manage custom folders](../docs/images/biz-mngr-role-webdav-manage-custom-folders.png)
20. Click **Apply**
21. Under **Impex**, select the _write_ checkbox for `/impex/src/feeds/export/*`
    - ![WebDAV Permissions](../docs/images/biz-mngr-role-webdav-permissions.png)
22. At the bottom of the screen, Click **Update**

#### Configure WebDAV Permissions
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Follow the steps from [Configure WebDAV Permissions](../README.md#white_check_mark-configure-webdav-permissions)

### Configure TikTok Marketing Integration
1. Log in to Business Manager
2. In Business Manager, Go to **Merchant Tools** > **Social Channels** > **TikTok for Business**
3. Click **Accept Terms** button
    - ![TikTok Accept Terms](../docs/images/tiktok-accept-terms.png)
4. Refer to the [onboarding configuration table](#tiktok-onboarding-configuration-table) for help in filling out the form
    - ![TikTok Onboarding Form](../docs/images/biz-mngr-tiktok-onboarding-form.png)
5. Select **Launch**
6. Click **Connect** to authorize Salesforce Commerce Cloud to connect with TikTok
    - ![TikTok Connect](../docs/images/tiktok-connect.png)
7. Login with your TikTok handle:
    - ![TikTok Login](../docs/images/tiktok-login.png)
8. Click **Authorize** to authorize TikTok For Business to access your TikTok account:
   - ![TikTok Authorize](../docs/images/tiktok-auth-business.png)
9. Next, you will be prompted to **Register** or **Log In** to your TikTok for Business account
   - Create a _new_ TikTok Business Account by clicking **Register** in the TikTok For Business account module.
   - Connect to an _existing_ TikTok Business account by clicking **Log In**.
   - ![TikTok Business Account](../docs/images/tiktok-create-login-biz-account.png)
10. Next, you will be prompted to **Create New** or **Connect** to your TikTok Business Center
    - Connect to an _existing_ TikTok Business Center by clicking **Connect** next to the Business Center you wish to use. Only Business Center accounts associated with your TikTok for Business accounts will appear in this module.
    - Create a _new_ TikTok Business Center by clicking **Create New** in the Business Center module.
    - ![TikTok for Business](../docs/images/tiktok-biz-center.png)
11. Next, you will be prompted to **create** or **connect** your TikTok Ad Account
    - Connect to an _existing_ TikTok Ad account by clicking **Connect** next to the Ad Account you wish to use.
    - Create a _new_ TikTok Ad account by clicking **Create New** in the Ad Account module.
    - ![TikTok Ad Account](../docs/images/tiktok-ad-account.png)
12. **Create a TikTok Pixel** - TikTok pixel, built on the powerful developer base code, enables you to track conversions, build custom audiences, and optimize product discovery. Creating a pixel is a required step, but Salesforce will not inject the pixel into your website. Follow the [TikTok Pixel](#tiktok-pixel---sync-shopper-activities-and-monitor-web-events) documentation for instructions on how to embed the TikTok pixel into your site to send shopper activities into TikTok.
    - Click **Create New** to create and install a new pixel
        - > **Note**: if you are an existing advertiser, you will be able to connect an existing pixel after the set-up process is complete. However, you will need to select “Create New” to complete this stage of the onboarding process.
        - ![Create TikTok Pixel](../docs/images/tiktok-pixel.png)
    - **Enable Advanced Matching** to improve the match rate between TikTok ad clicks and conversions taking place on your website.
        - ![TikTok Pixel Enable Advanced Matching](../docs/images/tiktok-pixel-adv-match.png)
13. **Product Catalog**: Set up _product catalog syncing_ by clicking **Create New**. This will create an automatic sync of your existing Salesforce Commerce Cloud catalog onto your TikTok profile.
    - ![Product Catalog](../docs/images/tiktok-product-catalog.png)
14. Once each section is complete, click **Finish Setup**. You will be redirected back to Salesforce Commerce Cloud Business Manager where you can see your connected TikTok application details:
    - `Business Center ID`
    - `Pixel ID`
    - ![TikTok Connected](../docs/images/tiktok-ad-connect.png)
    - > Note: If you see an additional pop-up with the options "Create Now" and "Start Later", click **Start Later** to be redirected back to Commerce Cloud Business Manager.
        - ![Start Later](../docs/images/tiktok-start-later.png)

### Sync Product Catalog and Inventory
1. Follow the steps from:
- [Sync Product Catalog and Inventory](#sync-product-catalog-and-inventory-2)
  - [Review Catalog Feed Configuration](#review-catalog-feed-configuration)
  - [Review Job Configuration](#review-job-configuration)
      - [Export Full Feeds](#export-full-feeds)
      - [Export Delta Feeds](#export-delta-feeds)

## TikTok Pixel - Sync Shopper Activities and Monitor Web Events
During set-up, a developer-mode Pixel was created, **but not installed** on your website. Complete these additional steps to add the TikTok pixel to your website. Complete the [TikTok Ads/Marketing Integration](#tiktok-adsmarketing-integration) and [Sync your Product Catalog](#sync-product-catalog-and-inventory-2) before you begin.

You can send shopper activities to TikTok, track conversions, and build custom audiences for optimized product discovery. Two options are available:
1. [Option 1 - Server-based Tracking](#option-1---server-based-tracking)
2. [Option 2 - Browser-based Tracking](#option-2---browser-based-tracking)

When the setup is complete, use the [Test Event Function](https://ads.tiktok.com/marketing_api/docs?rid=5ipocbxyw8v&id=1724255493685249) to verify your event setup:
![Test Event Function](../docs/images/tiktok-event-tracking.png)

### Option 1 - Server-based Tracking

- `int_tiktok_pixel`: the cartridge tracks the following events:
    1. `ViewContent` (Product Show)
    2. `AddToCart` (add item to cart)
    3. `InitiateCheckout` (begin checkout)
    4. `CompletePayment` (place order)

#### Upload Cartridge
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. From the root of the repo (`social_channel_integrations`), run: `npm run code:upload:tiktok:tracking` to upload the `int_tiktok_pixel` cartridge to your instance. Alternatively, manually upload the cartridge using the instructions below:
    - [Uploading SFCC Cartridges](../README.md#uploading-sfcc-cartridges)

#### Update Cartridge Paths
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

To update your **Site** cartridge path:
1. Log in to Business Manager
2. Go to **Administration** > **Sites** > **Manage Sites**
3. Select the site that you want to use. Example site identifier: `RefArch`
4. Click the **Settings** tab
5. In the Cartridges field, add the new cartridge `int_tiktok_pixel`. Example path: `int_tiktok_pixel:int_tiktok:int_social_base:app_storefront_base`

#### Enable Event Based Tracking
Enable or disable events tracked by the `tiktok-settings` record in the **SocialChannels** custom object.

1. Log in to Business Manager
2. Go to **Merchant Tools** > **Custom Objects** > **Custom Objects Editor**
3. From the _Object Type_ drop down, select **SocialChannels**
4. Click the **Find** button
5. Click the `tiktok-settings` record
6. Under the **Tracking** heading, enable/disable event tracking

![TikTok Tracking](../docs/images/tiktok-event-tracking-settings.png)

:warning: The default setting for `Event Tracking Mode - View Content (viewContentEventTracking)` is **-None-**, which uses _real-time service calls_. Setting the option to either Real Time or None, is not recommended for high traffic sites or during a flash sale. If you set the **Queue Events** option, run or schedule the **TikTok-WebEvents-Push** job more frequently. This job pushes the events to TikTok and clears **TikTokWebEvents** the custom object.

:information_source: The `Enable Advanced Matching Email` and `Enable Advanced Matching Phone` options can be set dynamically via the **TikTok-AdvanceMatching** job, which updates the custom object fields based on your pixel settings saved in TikTok. In business manager, go to: **Administration** > **Operations** > **Jobs** and select **TikTok-AdvanceMatching**.

#### Event Based Tracking Jobs
There are two jobs related to server-side tracking:

1. `TikTok-AdvanceMatching`: This job queries your TikTok pixel settings and updates the advanced matching settings (`Enable Advanced Matching Email` and `Enable Advanced Matching Phone`) in the **SocialChannels** custom object.
2. :warning: `TikTok-WebEvents-Push`: :warning: This job sends queued tracking events to TikTok. It is required to run frequently if you have enabled the **Queue Events** option for the `Event Tracking Mode - View Content (viewContentEventTracking)` setting. This job clears records from the **TikTokWebEvents** custom object.
    - :stop_sign: Failure to schedule the **TikTok-WebEvents-Push** job will fill up the custom objects and cause performance/platform issues.

### Option 2 - Browser-based Tracking
Embed the TikTok pixel into your site to send shopper activities into TikTok. For detailed steps, see [TikTok documentation](https://ads.tiktok.com/help/article?aid=10010829).

`int_tiktok` exposes a hook **app.template.htmlHead** that injects the TikTok pixel into the storefront. Add the following code snippet in [htmlhead.isml](../social_channels/cartridges/int_tiktok/cartridge/templates/default/common/htmlHead.isml#L44) to enable the pixel:
```html
<isprint value="${dw.system.HookMgr.callHook('app.template.htmlHead', 'htmlHead', pdict) || ''}" encoding="off" />
```

## [TikTok Shop/Checkout](../social_checkout)

### TikTok Shop Overview

TikTok Shop (a.k.a TikTok Checkout) is a module inside the _Social Checkout and Feeds Extension_, built from a set of SFCC business manager cartridges that enables commerce cloud merchandisers to improve the discoverability of their products and sell those products on TikTok. This is an extension that builds on top of the existing [Ads integration](#tiktok-for-business-integration).

Using the cartridges built for TikTok Shop, a customer can
1. Onboard onto TikTok Shop from within business manager
2. Publish an entire site catalog, or a category of products (and product updates/deletions) into TikTok
3. Publish inventory information for all products for a site into TikTok
4. Create shipment methods for TikTok within business manager:
   - if you choose 4PL (shipped by TikTok):
     - TTS001 (Standard)
     - TTS002 (Economy)
     - TTS003 (Express)
   - if you choose 3PL (shipped by seller):
     - TTS004 (Standard)
5. Synchronize orders and order statuses between TikTok and Salesforce

### TikTok Shop Integration Overview

When shoppers checkout on TikTok, the order is paid for (authorized and captured) on TikTok, and TikTok calls SFCC's API to inject the order into SFCC with ChannelType = `CHANNEL_TYPE_TIKTOK` (value `14` in an enum that maps to TikTok). The order is then exported to the customer's Order Management System using the existing export processes.

The order is fulfilled and the order status updates needs to be sent back to TikTok for the shopper to get the order status updates. TikTok handles the order status communications with the end shopper directly. All TikTok Orders are created in SFCC with a placeholder email ID and ChannelType = `CHANNEL_TYPE_TIKTOK`, so the customer communication from a merchant's system - either SFCC or OMS needs to be turned off for TikTok Orders. Since the payment is already captured on TikTok, the payment capture on the OMS system/down stream ERP system needs to be skipped for orders with channelType `CHANNEL_TYPE_TIKTOK` (`<channel-type>TikTok</channel-type>`)

### TikTok Shop Prerequisites
To integrate with TikTok Shop, please complete the following prerequisites:

1. Ensure you have met the required [SFCC Prerequisites](../README.md#prerequisites)
2. Create a [TikTok User Account / Handle](https://www.tiktok.com/signup)
3. It is recommended to **_NOT_** create a TikTok test shop in advance of the onboarding call.
   - > :stop_sign: **NOTE**: You need to work with your TikTok Account Manager to get allow-listed to use the TikTok Shop feature, as well as ensuring your TikTok shop is configured to use the SFCC channel.
4. Create a [SFCC Business User](https://help.salesforce.com/s/articleView?id=cc.b2c_account_manager_create_user.htm)
5. For your SFCC Business User, create an [Access Key](https://help.salesforce.com/s/articleView?id=cc.b2c_access_keys_for_business_manager.htm) with scope: `Agent User Login and OCAPI`
6. For the SFCC Business User, ensure the necessary permissions are assigned. For more details, see [Assign Business Manager Permissions](#assign-tiktok-shop-business-manager-permissions)

### TikTok Shop Installation Instructions

#### Install Dependencies
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Follow the steps from [Install Dependencies and Create dw.json](../README.md#install-dependencies-and-create-dwjson)

#### Upload TikTok Shop Cartridges
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

- `int_social_base`: This cartridge contains code shared by all the social channels. It should be applied to both the storefront and Business Manager cartridge paths.
- `bm_socialchannels`: This cartridge contains the Business Manager controllers/UI logic to provide a new Business Manager extension that the site admin can use to integrate with TikTok.
- `int_tiktok`: This cartridge contains the logic to integrate with TikTok. It contains the service definitions, logic to handle the customer object that stores the TikTok details, and the job which syncs the B2C Commerce product catalog with TikTok.
- `int_social_checkout`: This cartridge contains the logic to synchronize orders and order statuses between TikTok and Salesforce.
- `bc_library`: This library contains all shared code for various demandware community projects. Ported from [demandware-library](https://github.com/SalesforceCommerceCloud/demandware-library)
- `bm_socialfeeds`: The custom feeds Business Manager module allows merchants to easily create catalog feeds according to their needs. The framework uses a powerful generic export model which ensures reasonable performance while more feeds are added. The extension comes with a BM UI which is easily usable and does not require any technical background.
- `int_socialfeeds`: The custom feeds module allows merchants to easily create catalog feeds according to their needs. The framework uses a powerful generic export model which ensures reasonable performance while more and more feeds are added.

> **NOTE**: In order to upload cartridges via npm scripts, you will need to replicate the dw.json in the `social_channels`, `social_checkout`, and `social_feeds` directories. The npm scripts will attempt to create a symlink, but it might be necessary for you to manually create this symlink for your operating system.

1. From the root of the repo (`social_channel_integrations`), run: `npm run code:upload:tiktok:shop` to upload the `bm_socialchannels`, `int_tiktok`, `int_social_checkout`, `bc_library`, `bm_socialfeeds`, `int_socialfeeds` cartridges to your instance. Alternatively, manually upload the cartridge using the instructions below:
    - [Uploading SFCC Cartridges](../README.md#uploading-sfcc-cartridges)

#### Update TikTok Shop Cartridge Paths
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

To update your **Business Manager** cartridge path:
1. Log in to Business Manager
2. Go to **Administration** > **Sites** > **Manage Sites**
3. Under **Business Manager Site**, click the `Manage the Business Manager site` link.
4. Click the **Settings** tab
5. In the Cartridges field, add the new cartridges listed below. Example path: `int_socialfeeds:bm_socialfeeds:bc_library:bm_socialchannels:int_social_base`
    - int_socialfeeds
    - bm_socialfeeds
    - bc_library
    - bm_socialchannels
    - int_social_base

To update your **Site** cartridge path:
1. Log in to Business Manager
2. Go to **Administration** > **Sites** > **Manage Sites**
3. Select the site that you want to use. Example site identifier: `RefArch`
4. Click the **Settings** tab
5. In the Cartridges field, add the new cartridges listed below. It must be added before the path for app_storefront_base. Example path: `int_tiktok:int_social_checkout:int_socialfeeds:bc_library:int_social_base:app_storefront_base`
    - int_tiktok
    - int_social_checkout
    - int_socialfeeds
    - bc_library
    - int_social_base

#### Import TikTok Shop Data
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Follow the steps from [Import and Update Configuration Data -> Import Common Data](../README.md#white_check_mark-import-common-data)
2. Follow the steps from [Import TikTok Global Data](#import-tiktok-global-data)
3. Follow the steps from [Import TikTok Site Data](#import-tiktok-site-data)

#### Update TikTok Shop Site Preferences
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Log in to Business Manager
2. Go to **Merchant Tools** > **Site Preferences** > **Custom Site Preference Groups**
3. Click **TikTok**
4. Update **TikTok Order Checkout Email** (tiktokCustomerEmail): `tiktokshop@salesforce.com`
5. Update **Payment Method ID** (tiktokPaymentMethod): `SOCIAL_PAY`
6. Update **Plugin JS Version** (tiktokPluginJS): Leave default or specify specific version (e.g.: `https://sf16-scmcdn-va.ibytedtos.com/obj/static-us/tiktok-business-plugin/tbp_external_platform-v2.3.11.js`)
7. Update **Inventory List ID** (tiktokInventoryListID): Your default inventory list ID (e.g.: `inventory_m`)
8. Update **Verify WebDAV Credentials** (tiktokVerifyWebDav): `Yes` / `true`
9. Update **Verify BM Credentials** (tiktokVerifyBM): `Yes` / `true`
10. Click **Save**
- ![TikTok Shop Site Preferences](../docs/images/tiktok-site-prefs-shop.png)

#### Assign TikTok Shop Business Manager Permissions
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Log in to Business Manager
2. Go to **Administration** > **Organization** > **Roles & Permissions**
3. Select the role of your Business Manager user(s)
4. Click the **Business Manager Modules** tab
5. Select the specified Sites under **Sites** (e.g.: RefArch, RefArchGlobal)
6. Click **Apply**
    - ![Select Context - Sites](../docs/images/biz-mngr-select-context-sites.png)
7. Under **Custom Objects**, select the _write_ checkbox for `Custom Object Editor`
    - ![Custom Object Editor](../docs/images/biz-mngr-role-custom-object-editor.png)
8. Under **Ordering**, select the _write_ checkbox for `Orders`
    - ![Orders](../docs/images/biz-mngr-role-orders.png)
9. Under **Social Channels**, select the _write_ checkbox for `TikTok for Business`
    - ![TikTok for Business](../docs/images/biz-mngr-role-tiktok-for-business.png)
10. At the bottom of the screen, Click **Update**
11. At the top of **Business Manager Modules** tab, switch context to **Organization**
12. Click **Apply**
    - ![Select Context - Org](../docs/images/biz-mngr-select-context-org.png)
13. Under **Operations**, select the _write_ checkbox for `Jobs`
14. Under **Operations**, select the _write_ checkbox for `Job History`
    - ![Job Permissions](../docs/images/biz-mngr-role-jobs.png)
15. Under **Social Product Feeds**, select the _write_ checkbox for **Social Product Feeds Definition**
    - ![Social Product Feeds Definition](../docs/images/biz-mngr-role-social-product-feeds-definition.png)
16. At the bottom of the screen, Click **Update**
17. Click the **Functional Permissions** tab
18. Select the specified Sites under **Sites** (e.g.: RefArch, RefArchGlobal)
19. Click **Apply**
    - ![Select Context - Sites](../docs/images/biz-mngr-select-context-sites.png)
20. Assign the following permissions:
    - `Login_On_Behalf`
    - `Delete_Order_Note`
    - `Create_Order_On_Behalf_Of`
    - `Search_Orders`
    - `Handle_External_Orders`
21. At the bottom of the screen, Click **Update**
22. Click the **WebDAV Permissions** tab
23. Scroll to the **Impex** section
24. Click the **Manage custom folders** link
25. In the text box, enter: `src/feeds/export`
    - ![Manage custom folders](../docs/images/biz-mngr-role-webdav-manage-custom-folders.png)
26. Click **Apply**
27. Under **Impex**, select the _write_ checkbox for `/impex/src/feeds/export/*`
    - ![WebDAV Permissions](../docs/images/biz-mngr-role-webdav-permissions.png)
28. At the bottom of the screen, Click **Update**

#### Configure WebDAV Permissions
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

1. Follow the steps from [Configure WebDAV Permissions](../README.md#white_check_mark-configure-webdav-permissions)

#### Configure OCAPI Permissions
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

##### Data API
1. Log in to Business Manager
2. Go to **Administration** > **Site Development** > **Open Commerce API Settings**
3. Select **Type**: `Data`
4. Select **Context**: `Global`
5. Update the **Data API** settings as follows:

```json
{
    "_v": "21.3",
    "clients": [
        {
            "client_id": "[-------OCAPI Account Manager Client ID-------]",
            "resources": [
                {
                    "resource_id": "/user_search",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                }
            ]
        }
    ]
}
```

##### Shop API
1. Log in to Business Manager
2. Go to **Administration** > **Site Development** > **Open Commerce API Settings**
3. Select **Type**: `Shop`
4. Select **Context**: `Global`
5. Update the **Shop API** settings as follows:

```json
{
    "_v": "21.3",
    "clients": [
        {
            "client_id": "[-------OCAPI Account Manager Client ID-------]",
            "resources": [
                {
                    "resource_id": "/order_search",
                    "methods": ["post"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/orders/*",
                    "methods": ["get", "patch", "put"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                },
                {
                    "resource_id": "/products/*/availability",
                    "methods": ["get"],
                    "read_attributes": "(**)",
                    "write_attributes": "(**)"
                }
            ]
        }
    ]
}
```

#### Configure Pipeline URL Alias
Create Pipeline URL alias for Create Order custom controller:

1. Log in to Business Manager
2. Go to **Merchant Tools** > **SEO** > **URL Rules**
3. Click the **Pipeline URLs** tab
4. In the **Pipeline Aliases** section, enter a new alias for the `OrderCreate-Social` controller:
   - **Alias**: `CreateExternalOrder`
   - **Pipeline**: `OrderCreate-Social`
5. Click **Apply**
![TikTok Pipeline URL Alias](../docs/images/biz-mngr-tiktok-pipeline-url-alias.png)

#### Configure Order Settings
To prevent duplicate orders from being created, the create external order controller queries orders to ensure that the order does not already exist. In order for this check to work properly, make the following order settings changes:

1. Log in to Business Manager
2. Go to **Merchant Tools** > **Site Preferences** > **Order**
3. In the **Order Access Settings**, make the following updates:
   - **Limit Storefront Order Access**: `No`
   - **Storefront Order Filter by Customer Session**: `No`
   - ![Order Access Settings](../docs/images/biz-mngr-order-access-settings.png)
4. Click **Apply**

### Configure TikTok Shop Integration
1. Log in to Business Manager
2. In Business Manager, Go to **Merchant Tools** > **Social Channels** > **TikTok for Business**
3. Click **Accept Terms** button
    - ![TikTok Accept Terms](../docs/images/tiktok-accept-terms.png)
4. Refer to the [onboarding configuration table](#tiktok-onboarding-configuration-table) for help in filling out the form
    - ![TikTok Onboarding Form](../docs/images/biz-mngr-tiktok-onboarding-form.png)
5. Select **Launch**
6. :warning: :stop_sign: If this is your first time installing on the sandbox, DO NOT click the **Connect** button in the next step as your `External Business ID` needs to be added to the allow list by TikTok _prior_ to proceeding. Follow the steps below _before_ proceeding to click **Connect**. :stop_sign: :warning:
    1. In Business Manager, proceed to: **Site** > **Merchant Tools** > **Custom Objects** > **Custom Object Editor**
    2. From the **Object Type** dropdown, select `SocialChannels`
    3. Click **Find**
    4. Click the `tiktok-settings` record:
        - ![TikTok Settings](../docs/images/biz-mngr-tiktok-settings.png)
    5. Locate the External Business ID, copy the value and send to TikTok for allow listing:
        - ![TikTok Settings](../docs/images/biz-mngr-tiktok-ext-biz-id.png)
    6. Once TikTok confirms the External Business ID has been added to the allow list, you may continue with the onboarding process.
7. Click **Connect** to authorize Salesforce Commerce Cloud to connect with TikTok
    - :warning: If this is your first time installing on the sandbox, DO NOT click the **Connect** button until TikTok has added your `External Business ID` to the allow list. Please see step #6 above. :warning:
    - ![TikTok Connect](../docs/images/tiktok-connect.png)
8. If your account has been allow-listed to use the TikTok Shop feature, you will be prompted to select either the TikTok Marketing or TikTok Shop feature:
    - Select `TikTok Shop`
    - ![TikTok Feature](../docs/images/tiktok-select-feature.png)
9. Login with your TikTok handle:
    - ![TikTok Login](../docs/images/tiktok-login.png)
10. Click **Authorize** to authorize TikTok For Business to access your TikTok account:
    - ![TikTok Authorize](../docs/images/tiktok-auth-business.png)
11. Next, you will be prompted to **Register** or **Log In** to your TikTok Shop account
    - Create a _new_ TikTok Shop account by clicking **Register**.
    - Connect to an _existing_ TikTok Shop account by clicking **Log In**.
    - ![TikTok Shop Account](../docs/images/tiktok-shop-create-login-account.png)
12. Seller Verification: click **Start** to enter and verify your shop information. Optionally, you can complete this information in the TikTok Shop Seller Center.
    - ![Seller Verification](../docs/images/tiktok-shop-seller-verification.png)
13. Warehouse Information: click **Start** to enter and verify your warehouse information. Optionally, you can complete this information in the TikTok Shop Seller Center.
    - ![Warehouse Information](../docs/images/tiktok-warehouse-information.png)
14. Shipping Template: click **Start** to set up your shipping template. Optionally, you can complete this information in the TikTok Shop Seller Center.
    - ![Warehouse Information](../docs/images/tiktok-shop-shipping-template.png)
15. Once each section is complete, click **Finish Setup**.
    - ![Finish Setup](../docs/images/tiktok-shop-finish-setup.png)
16. On the final step, you can choose **Set up now** to set up [TikTok Marketing](#configure-tiktok-marketing-integration) or choose **Maybe later** to be redirected back to Salesforce Commerce Cloud Business Manager where you can see your connected TikTok application details.
    - ![TikTok Shop Confirmation](../docs/images/tiktok-shop-complete.png)

### Sync Product Catalog, Inventory, and Export Orders Status
1. Follow the steps from:
- [Sync Product Catalog and Inventory](#sync-product-catalog-and-inventory-2)
    - [Review Catalog Feed Configuration](#review-catalog-feed-configuration)
    - [Review Job Configuration](#review-job-configuration)
        - [Export Full Feeds](#export-full-feeds)
        - [Export Delta Feeds](#export-delta-feeds)
        - [Export Order Status](#export-order-status)

### Order Management System (OMS) Integration
Please review and complete the steps from the [Order Management System Integration](./oms.md#overview) document.

#### Additional notes

When using the OMS Integration and an order update event happens between OMS and SFCC (e.g.: order is shippend or cancelled), it also proceeds to update orders status on TikTok side.

### Omnichannel Inventory (OCI) Integration
In case the storefront has [Omnichannel Inventory](https://help.salesforce.com/s/articleView?id=cc.b2c_inventory_management_omnichannel_inventory.htm) enabled, the native inventory export won't generate accurate inventory.

Please complete the steps from the [Omnichannel Inventory Integration](./oci.md) document. After doing so, remove the standard inventory export from the **TikTok-ExportFullFeeds** job:
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click on the `TikTok-ExportFullFeeds` job
4. Click on the **Job Steps** tab
5. In the second flow which contains the **ExportInventoryLists** and **TikTok Notify Inventory Feed Ready** steps, click the trash can icon to delete the flow:
   - ![Remove Inventory Flow](../docs/images/biz-mngr-tiktok-export-feeds-remove-inv-flow.png)
6. Return **Administration** > **Operations** > **Jobs**
7. Click on the `OCI-Download-Full-Inventory` job
8. Click on the **Job Steps** tab
9. Under the `Download Inventory File from OCI` step, click the `+` sign to add a new job step.
    - ![TikTok OCI Job Steps](../docs/images/tiktok-oci-job-steps.png)
10. In the filter box, enter: `TikTokNotifyFeedReady`
11. Configure the job step:
    - **ID**: `TikTok Notify Inventory Feed Ready`
    - **FeedType**: `inventory`
    - **UpdateType**: `create`
    - **FileFolder**: `/src/feeds/export/oci/full` (the file location relative to IMPEX)
    - ![TikTok Notify Inventory Feed Ready (Create)](../docs/images/tiktok-oci-notify-create.png)
12. Click **Assign**
13. Return **Administration** > **Operations** > **Jobs**
14. Click on the `OCI-Download-Delta-Inventory` job
15. Click on the **Job Steps** tab
16. Under the `Delta Export` step, click the `+` sign to add a new job step.
     - ![TikTok OCI Job Steps](../docs/images/tiktok-oci-job-steps-delta.png)
17. In the filter box, enter: `TikTokNotifyFeedReady`
18. Configure the job step:
     - **ID**: `TikTok Notify Inventory Feed Ready`
     - **FeedType**: `inventory`
     - **UpdateType**: `update`
     - **FileFolder**: `/src/feeds/export/oci/delta` (the file location relative to IMPEX)
     - ![TikTok Notify Inventory Feed Ready (Update)](../docs/images/tiktok-oci-notify-update.png)
19. Click **Assign**

## Global Installation Instructions

### Import TikTok Global Data
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

TikTok Global data is found in [data/tiktok/tiktok_global](../data/tiktok/tiktok_global).

#### Option 1: Via npm scripts using [sfcc-ci](https://github.com/SalesforceCommerceCloud/sfcc-ci)
1. From the root of the repo (`social_channel_integrations`), run: `npm run data:import:tiktok:global`
    - This will zip, upload, and import the data files into the sandbox specified in your dw.json file.

#### Option 2: Manually Zip, Upload, and Import via Business Manager
1. Zip the [data/tiktok/tiktok_global](../data/tiktok/tiktok_global) folder. From the root of the repo, run: `npm run data:tiktok:global:zip` (or manually zip the folder)
2. Log in to Business Manager
3. Go to **Administration** > **Site Development** > **Site Import & Export**
4. Click **Browse**
5. Select the `tiktok_global.zip` file from the root of the repo
6. Click **Upload**.
7. Select `tiktok_global.zip`
8. Click **Import**.
9. Click **OK**.

### Import TikTok Site Data
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

TikTok Global site is found in [data/tiktok/tiktok_site](../data/tiktok/tiktok_site).

#### Option 1: Via npm scripts using [sfcc-ci](https://github.com/SalesforceCommerceCloud/sfcc-ci)
1. From the root of the repo (`social_channel_integrations`), run: `npm run data:import:tiktok:site`
    - This will rename the site directory, zip, upload, and import the data files into the sandbox specified in your dw.json file.

#### Option 2: Manually Rename Site Directory, Zip, Upload, and Import via Business Manager
1. Rename the [RefArch](../data/tiktok/tiktok_site/sites/RefArch) site folder to your site ID. From the root of the repo, run: `npm run data:tiktok:site:prepare` (or manually rename the folder)
2. Zip the [data/tiktok/tiktok_site](../data/tiktok/tiktok_site) folder. From the root of the repo, run: `npm run data:tiktok:site:zip` (or manually zip the folder)
3. Log in to Business Manager
4. Go to **Administration** > **Site Development** > **Site Import & Export**
5. Click **Browse**
6. Select the `tiktok_site.zip` file from the root of the repo
7. Click **Upload**.
8. Select `tiktok_site.zip`
9. Click **Import**.
10. Click **OK**.

#### TikTok Onboarding Configuration Table

##### Salesforce B2C Commerce Onboarding Details
| **Field Name**                                  | **Details**                                                                                                                                          |
|-------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Account Manager Client ID**                   | The Account Manager Client ID you set up in Account Manager                                                                                          |
| **Account Manager Client Secret**               | The secret/password for your Client ID above                                                                                                         |
| **Business Manager User Login**                 | Business Manager login ID                                                                                                                            |
| **Business Manager User Access Key / Password** | Business Manager ["Agent User Login and OCAPI" access key](https://help.salesforce.com/s/articleView?id=cc.b2c_access_keys_for_business_manager.htm) |
| **WebDAV Client ID**                            | The Account Manager Client ID you set up in Account Manager                                                                                          |
| **WebDAV Client Secret**                        | The secret/password for your Client ID above                                                                                                         |
| **Org ID**                                      | Salesforce Commerce API Org ID. Found at Administration > Site Development > Salesforce Commerce API Settings (e.g.: `f_ecom_zzte_053`)              |
| **Storefront Hostname Alias**                   | The hostname alias for your site. This must already be defined in your site's alias configuration at Merchant Tools > SEO > Aliases                  |

##### TikTok Onboarding Details
The TikTok details are used in the creation of TikTok assets like the Catalog and Ad Account so please make sure these details match the information associated with the site
| **Field Name**   | **Details**                                                                        | **Ads / Shop / Both** |
|------------------|------------------------------------------------------------------------------------|-----------------------|
| **Email**        | Email for the business user                                                        | Both                  |
| **Phone**        | Phone number of the business user                                                  | Both                  |
| **Country Code** | Region that the website serves                                                     | Both                  |
| **Website URL**  | The URL for the site (e.g.: `https://abcd-001.dx.commercecloud.salesforce.com`)    | Both                  |
| **Industry ID**  | Industry for your site                                                             | Both                  |


### Sync Product Catalog and Inventory

Once the integration between B2C Commerce and TikTok is complete, you can enable the product catalog sync by enabling the B2C Commerce job that sends the products to TikTok.

#### Review Catalog Feed Configuration

Catalog feed configurations are based on the [custom feeds module](https://github.com/SalesforceCommerceCloud/custom-feeds) which allows merchants to easily create catalog feeds according to their needs. Once you define the template, you can schedule the feed to run at desired intervals. It is recommended to run this job at the same frequency you anticipate changes to your catalog, or whenever you replicate to production.

1. Log in to Business Manager
2. Go to **Administration** > **Social Product Feeds** > **Social Product Feeds Definition**

| **Field**                    | **Description**                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       |
|------------------------------|---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| **Template**                 | The default feed configuration will be loaded into the `tiktok-feed` record within the **SalesChannelFeedConfig** custom object. Initial configuration is based on the SFRA reference website. It is recommended to review the header and field mapping according to the catalog setup for your storefront and update it as required. Product field mappings can be found in [Social Product Feeds](./feedConfig.md). Possible areas of interest:<br/><ul><li>`imageJsonData type="large"`: configure proper image view type that should be exported</li><li>`price type="usd-m-list-prices"`: configure the list pricebook</li></ul> |
| **Folder Name**              | `IMPEX/src/feeds/export/social/tiktok/product`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        |
| **File Name**                | `tiktok-feed-{{site_id}}-{{timestamp}}-{{locale}}.txt`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                |
| **Category Specific Export** | The category to export. Enter `root` to export all products or a specific category (e.g.: `social-tiktok`). Ensure the category you select is marked as "online".                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| **Channel Type**             | `TikTok`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              |
| **Google Shopping Category** | Category based on the kind of products that are sold on your site                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     |
| **Available for Sites**      | The site(s) for which the products need to be exported. It is recommended to run & configure a feed template once per site. Custom object IDs can be defined in the `CustomObjectIds` job parameter within the **Product Full Feed** job step in the `TikTok-ExportFullFeeds` scheduled job.                                                                                                                                                                                                                                                                                                                                          |

#### Review Job Configuration

##### Export Full Feeds
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click on the `TikTok-ExportFullFeeds` job
4. Click on the **Job Steps** tab and configure job steps
    - **Product Full Feed**
        - Check `ExportCatalogs`
        - Check `GenerateDeleteFeed`
            - There will be a separate file created for deleted products letting TikTok know about the products that are deleted.
            - **NOTE**: The products in the delete feed are difference in the current run of the full feed to the previous run. If a product is unassigned from a category, deleted from a category, the product will show up in the delete feed. If you are NOT including offline products and NOT including out of stock products in the full feed, make sure the products are categorized, online, searchable and in-stock. If a product goes from searchable to un-searchable between two subsequent runs, it will show up in the delete feed because the full feed relies on the search index.
            - **NOTE**: If you manually create a delete file for TikTok to consume, the line endings should be line feed, `LF` (`\n`) instead of carriage return `CR` (`\r`) or `CRLF` (`\r\n`).
        - Configure `CustomObjectIds`, comma separated custom object IDs used to build a feed (e.g.: `tiktok-feed`)
        - > :exclamation: Please, note that this job step requires a pre-built product index when you set a specific category (instead of `root`) in your feed configuration object
        - Configure `Hostname`
        - Click **Assign**
        - ![TikTok Export Product](../docs/images/biz-mngr-tiktok-export-feeds-product-full-feed.png)
    - **TikTok Notify Product Feed Ready**
        - **FeedType**: `product`
        - Click **Assign**
        - ![TikTok Notify Product](../docs/images/biz-mngr-tiktok-export-feeds-product-notify.png)
    - **ExportInventoryLists** (see [Omnichannel Inventory instructions](#omnichannel-inventory-oci-integration))
        - Configure `InventoryListIDs`
        - Check `OverwriteExportFile`
        - **FileNamePrefix**: `feeds/export/social/tiktok/inventory/inventory`
        - Click **Assign**
        - ![TikTok Export Inventory](../docs/images/biz-mngr-tiktok-export-feeds-inventory-feed.png)
    - **TikTok Notify Inventory Feed Ready**
        - **FeedType**: `inventory`
        - Click **Assign**
        - ![TikTok Notify Inventory](../docs/images/biz-mngr-tiktok-export-feeds-inventory-notify.png)
5. Click **Run Now** or click the **Schedule and History** tab to schedule the job to run

##### Export Delta Feeds
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click on the `TikTok-ExportDeltaFeeds` job
4. Click on the **Job Steps** tab and configure job steps
    - **Product Delta Feed**
        - Check `ExportCatalogs`
        - Check `GenerateDeleteFeed`
            - There will be a separate file created for deleted products letting TikTok know about the products that are deleted.
            - **NOTE**: If you manually create a delete file for TikTok to consume, the line endings should be line feed, `LF` (`\n`) instead of carriage return `CR` (`\r`) or `CRLF` (`\r\n`).
        - Configure `CustomObjectIds`, comma separated custom object IDs used to build a feed (e.g.: `tiktok-feed`)
        - > :exclamation: Please, note that this job step requires a pre-built product index when you set a specific category (instead of `root`) in your feed configuration object
        - Configure `DeltaCatalogInDays`, `0.1` until `1` (`0.1` = 2.4 hours; `0.2` = 4.8 hours;...; `1` = 24 hours)
        - Configure `Hostname`
        - Click **Assign**
        - ![TikTok Export Product](../docs/images/biz-mngr-tiktok-export-feeds-product-delta-feed.png)
    - **TikTok Notify Product Feed Ready**
        - **FeedType**: `product`
        - Click **Assign**
        - ![TikTok Notify Product](../docs/images/biz-mngr-tiktok-export-feeds-product-notify.png)

5. Click **Run Now** or click the **Schedule and History** tab to schedule the job to run

##### Export Order Status
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click the `TikTok-ExportOrderStatus` job
4. Click the **Job Steps** tab and configure job steps
    - **ExportOrders**
        - The following table shows the main attributes available:

        | **Step Parameter** | **Description**                                                             |
        |--------------------|-----------------------------------------------------------------------------|
        | FileName           | The name of the file that will be generated 
        | FileFolder         | The folder where the file will be generated
        | SocialChannel      | The channel the order will be filtered on    
        - Configure `FileName`, set the order export filename (e.g.: `TikTokOrderStatusUpdate`)        
        - Configure `FileFolder`, set the folder where the feed will be generated.
        - > :exclamation: Please note that this Path is relative to **_IMPEX/_**.
        - Configure `SocialChannel`, select `TikTok`
        - Click **Assign**
        - ![TikTok Export Orders Status](../docs/images/biz-mngr-tiktok-export-orders-status.png)

5. Click **Run Now** or click the **Schedule and History** tab to schedule the job to run

- > :exclamation: Note that this job exports all orders, without exception, that have the 'channelType' attribute value equals to `TikTok` and the `externalExportStatus` custom attribute value equals to `EXPORT_STATUS_READY`**(2)**. 

- > :exclamation: This job is for  US only, disable it for UK sites. For all UK sites, use the [processOrderUpdatesHook](../social_channels/cartridges/int_tiktok/cartridge/scripts/services/tiktokService.js) to send order statuses in a synchronous manner to TikTok. For UK sites, call the ORDER PATCH API to update order status and the processOrderUpdatesHook after patch hook will update order status to tiktok. 
