# Third-party OMS - Meta Integration

This document is intended for environments with third-party order management systems other than Salesforce OMS, as it contains order management scenarios supported by Meta integration. All scenarios are described since customizations will be necessary for order management to communicate with Meta. This repository contains the cartridges `int_order_som` and `int_order_no_oms` which provide hooks for these scenarios. It is possible to base your code on them to write from scratch, overwrite, or extend the hooks to best fit the specific environment scenario as long as the final state of order and line items properties are maintained. Whenever there are changes to an order, the job found in this repository named `Instagram-ExportOrders` searches for orders that had changes and notifies Meta of which order numbers Meta should make a GET request for to receive the updates.

## Meta - Order Management

- [Order gets shipped](#order-gets-shipped)
- [Cancellation of the entire order](#cancellation-of-the-entire-order)
- [Cancellation of a specific line item](#cancellation-of-a-specific-line-item)
- [Return of the entire order](#return-of-the-entire-order)
- [Return of the entire order - Seller approves on Meta](#return-of-the-entire-order---seller-approves-on-meta)
- [Return of a specific line item](#return-of-a-specific-line-item)
- [Return of a specific line item - Seller approves on Meta](#return-of-a-specific-line-item---seller-approves-on-meta)
- [Refund of the entire order](#refund-of-the-entire-order)
- [Refund of a specific line item](#refund-of-a-specific-line-item)
- [Shipment refund](#shipment-refund)
- [Appeasement](#appeasement)

## Order gets shipped

![Order gets shipped](./images/3p-oms-shipped.png)

In this scenario, for the OMS to indicate that the order is shipped, a payload is sent to the order patch, which updates the status by setting `externalChannelOrderStatus` to `5 - COMPLETED`, `shippingStatus` to `2 - SHIPPED`, and for each line item, provides the `trackingNumber`, `carrier`, `shipmentQuantity` of the delivery, and changes the `externalLineItemStatus` to `2 - SHIPPING_STATUS_SHIPPED`.

Request from 3P OMS to SFCC

OCAPI SHOP API - Update order - [PATCH]
  ```https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}```

```json
{
    "c_orderAction": "update",
    "product_items": [
        {
            "product_id": "701642489030M",
            "c_externalLineItemStatus": 2,
            "c_trackingNumber": "123456789",
            "c_carrier": "Fedex",
            "c_shipmentQuantity": 1.00,
            "c_OMSShipmentId": "0OBHr000000NOU7OAO"
        }
    ],
    "c_externalChannelOrderStatus": 5,
    "c_externalExportStatus": 2,
    "c_hasMultishipping": false,
    "shipping_status": "shipped"
}
```

## Cancellation of the entire order

![Cancellation of the entire order](./images/3p-oms-cancellation-order.png)

In this scenario, the shopper will request the order cancellation, so Meta will use an order patch request specifying ``c_orderAction`` as ``cancel_order``, which will trigger the ``app.order.cancel.processCancelOrder`` hook. This hook will call to consult and notify the OMS that the order will be canceled. The order field ``externalChannelOrderStatus`` will be changed to ``6 - Cancelled``, and for each line item, the field externalLineItemStatus will be updated to ``6 - Cancelled``.

Request from META to SFCC

OCAPI SHOP API - Update order - [PATCH]
  ``https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}``

```json
{
    "c_orderAction": "cancel_order",
    "c_cancelInfo": {
        "requestor": "InstagramShops",
        "reason": "IG_CUSTOMER_REQUEST",
        "note": "explanation of the cancelation"
    }
}
```

## Cancellation of a specific line item

![Cancellation of a specific line item](./images/3p-oms-cancellation-line-item.png)

In this scenario, the shopper will request the cancellation of a line item from the order (which can be partial). Therefore, Meta will use an order patch request specifying `c_orderAction` as `cancel`, which will trigger the `app.order.cancel.processCancel` hook. This hook will make a call to consult and notify the OMS that some line items of the order will be canceled. The order field `externalChannelOrderStatus` will be changed to  `7- CANCELLED_PARTIAL`, and for the specified line items, the field a will be updated to `6 - CANCELLED` or `7 - CANCELLED_PARTIAL`.

Request from META to SFCC

OCAPI SHOP API - Update order- [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "cancel",
    "c_cancelInfo": {
        "requestor": "InstagramShops",
        "cancelItems": {
            "701642489030M": {
                "quantity": "1",
                "reason": "IG_CUSTOMER_REQUEST"
            }
        }
    }
}
```

## Return of the entire order

![Return of an entire order](./images/3p-oms-return-order.png)

In this scenario, the shopper will request the return of the order. Therefore, Meta will use an order patch request with the payload containing the property `c_orderAction` as `return_request`. This will trigger the `app.order.return.processReturnRequest` hook. Then, a return request will be created in the OMS, and the field `externalReturnStatus` and `externalLineItemReturnStatus` will be changed to `1 - NEW`. After the seller confirms through the OMS that the return is authorized, the OMS should update SFCC with the new status of the `externalReturnStatus` and `externalLineItemReturnStatus` property to the value `2 - CONFIRMED`. For each item, the property linking the shopper to download the return collection label will be provided. Once the RMA process is finalized, a new call should be made to SFCC to update the `externalReturnStatus` and `externalLineItemReturnStatus` field to the value `4 - RETURNED` and, for each line item, the `quantityReceived`, `quantityReturned`.

Request from META to SFCC

OCAPI SHOP API - Update order - [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "return_request",
    "c_returnCase": {
        "requestor": "Customer",
        "reason": "Unknown"
    }
}
```

Request from 3P OMS to SFCC - Return Request approved

OCAPI SHOP API - Update order - [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "update",
    "c_externalReturnStatus": 2,
    "product_items": [
        {
            "product_id": "701642489030M",
            "c_externalLineItemReturnStatus": 2,
            "c_returnShippingLabel": "www.tracking.com/label?id=123456789" 
        }
    ]
}
```

Request from 3P OMS to SFCC - RMA process completed

OCAPI SHOP API - Update order - [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "update",
    "c_externalReturnStatus": 4,
    "product_items": [
        {
            "product_id": "701642489030M",
            "c_quantityReceived": 1.0,
            "c_quantityReturned": 1.0,
            "c_quantityRejected": 0.0,
            "c_externalLineItemReturnStatus": 4
        }
    ]
}
```

## Return of the entire order - Seller approves on Meta

![Return of the entire order - Seller approves on Meta](./images/3p-oms-return-order-request.png)

In this scenario, the shopper requests a return for the entire order, and the seller approves the return and generates the return label in Meta. Meta uses an order patch request with `c_orderAction` as `return_request` and the status property set to `EXTERNALLY_APPROVED`, This will trigger the `app.order.return.processReturnRequest` hook. Then, a return request already approved will be created in the OMS, and the field `externalReturnStatus` and `externalLineItemReturnStatus` will be changed to  `2 - CONFIRMED` on SFCC order. Once the RMA process is finalized, a new call should be made to SFCC to update the `externalReturnStatus` and `externalLineItemReturnStatus` field to the value `4 - RETURNED` and, for each line item, the `quantityReceived`, `quantityReturned`.thus creating the return request already approved in the OMS.

Request from META to SFCC

OCAPI SHOP API - Update order - [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "return_request",
    "c_returnCase": {
        "requestor": "Customer",
        "reason": "Unknown",
        "status": "EXTERNALLY_APPROVED"
    }
}
```

Request from 3P OMS to SFCC - RMA process completed

OCAPI SHOP API - Update order - [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "update",
    "c_externalReturnStatus": 4,
    "product_items": [
        {
            "product_id": "701642489030M",
            "c_quantityReceived": 1.0,
            "c_quantityReturned": 1.0,
            "c_quantityRejected": 0.0,
            "c_externalLineItemReturnStatus": 4
        }
    ]
}
```

## Return of a specific line item

![Return of a specific line item](./images/3p-oms-return-line-item.png)

In this scenario, the shopper will request the return of a specific line item. Therefore, Meta will use an order patch request with the payload containing the property `c_orderAction` as `return`. This will trigger the `app.order.return.processReturnItem` hook. Then, a return request will be created in the OMS, and the field `externalReturnStatus` and `externalLineItemReturnStatus` will be changed to `1 - NEW`. After the seller confirms through the OMS that the return is authorized, the OMS should update SFCC with the new status of the `externalReturnStatus` and `externalLineItemReturnStatus` property to the value `2 - CONFIRMED`. For each item, the property linking the shopper to download the return collection label will be provided. Once the RMA process is finalized, a new call should be made to SFCC to update the `externalReturnStatus` with `5 - PARTIAL_RETURN` and `externalLineItemReturnStatus` field to the value `4 - RETURNED` or `5 - PARTIAL_RETURN` and, for each line item, the `quantityReceived`, `quantityReturned`.

Request from META to SFCC

OCAPI SHOP API - Update order - [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "return",
    "c_returnCase": {
        "requestor": "Customer",
        "returnItems": {
            "701642923831M": {
                "quantity": "1",
                "reason": "Unknown",
                "restockingfee": -1.00
            }
        }
    }
}
```

Request from 3P OMS to SFCC - Return Request approved

OCAPI SHOP API - Update order - [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "update",
    "c_externalReturnStatus": 2,
    "product_items": [
        {
            "product_id": "701642489030M",
            "c_externalLineItemReturnStatus": 2,
            "c_returnShippingLabel": "www.tracking.com/label?id=123456789" 
        }
    ]
}
```

Request from 3P OMS to SFCC - RMA process completed

OCAPI SHOP API - Update order - [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "update",
    "c_externalReturnStatus": 5,
    "product_items": [
        {
            "product_id": "701642489030M",
            "c_quantityReceived": 1.0,
            "c_quantityReturned": 1.0,
            "c_quantityRejected": 0.0,
            "c_externalLineItemReturnStatus": 4
        },{
            "c_restockingFee": 1.05,
            "product_id": "1OsHr000000VnNVKA0"
        }
    ]
}
```

## Return of a specific line item - Seller approves on Meta

![Return of a specific line item](./images/3p-oms-return-line-item-request.png)

In this scenario, the shopper requests a return for specific line item, and the seller approves the return and generates the return label in Meta. Meta uses an order patch request with `c_orderAction` as `return` and the status property set to `EXTERNALLY_APPROVED`, This will trigger the a`pp.order.return.processReturnRequest` hook. Then, a return request already approved will be created in the OMS, and the field `externalReturnStatus` and `externalLineItemReturnStatus` will be changed to  `2 - CONFIRMED` on SFCC order. Once the RMA process is finalized, a new call should be made to SFCC to update the externalReturnStatus and  field to the value `5 - PARTIAL_RETURN` and `externalLineItemReturnStatus` field to the value `4 - RETURNED` or `5 - PARTIAL_RETURN` and, for each line item, the `quantityReceived`, `quantityReturned`.

Request from META to SFCC

OCAPI SHOP API - Update order - [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`


```json
{
    "c_orderAction": "return",
    "c_returnCase": {
        "requestor": "Customer",
        "status": "EXTERNALLY_APPROVED"
        "returnItems": {
            "701642923831M": {
                "quantity": "1",
                "reason": "Unknown"
            }
        }
    }
}
```


Request from 3P OMS to SFCC - RMA process completed

OCAPI SHOP API - Update order - [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "update",
    "c_externalReturnStatus": 5,
    "product_items": [
        {
            "product_id": "701642489030M",
            "c_quantityReceived": 1.0,
            "c_quantityReturned": 1.0,
            "c_quantityRejected": 0.0,
            "c_externalLineItemReturnStatus": 4
        }
    ]
}
```

## Refund of the entire order

![Refund of the entire order](./images/3p-oms-refund-order.png)

In this scenario, the shopper requests the return of the entire order, and the seller approves the refund on Meta without requiring the product to be returned. Therefore, Meta makes an order patch request with the property `c_orderAction` as `refund_order`, which triggers `app.order.refund.processRefundOrder`. Then, SFCC will notify the OMS that the items have been refunded and update the fields `externalChannelOrderStatus`, `externalReturnStatus` and `externalLineItemReturnStatus` to `8 - REFUNDED`.

META to SFCC

```json
{
    "c_orderAction": "refund_order",
    "c_returnCase": {
        "requestor": "Customer",
        "reason": "Unknown",
        "note": "reason for return",
        "status": "approved_external"
    }
}
```

## Refund of a specific line item

![Refund of a specific line item](./images/3p-oms-refund-line-item.png)

In this scenario, the shopper requests the return of a specific line item, and the seller approves the refund on Meta without requiring the product to be returned. Therefore, Meta makes an order patch request with the property `c_orderAction` as `refund`, which triggers `app.order.refund.processRefund`. Then, SFCC will notify the OMS that the items have been refunded and update the fields `externalChannelOrderStatus`, `externalReturnStatus` with `9 - PARTIAL_REFUND` and `externalLineItemReturnStatus` to `8 - REFUNDED`.

META to SFCC

```json
{
    "c_orderAction": "refund",
    "c_returnCase": {
        "requestor": "Customer",
        "returnItems": {
            "701642489030M":{
                "quantity":"1",
                "reason":"Unknown",
                "note": "explanation of the refund",
                "status" : "approved_external"
                }
            }
        }
}
```

## Shipment refund

![Shipment refund](./images/3p-oms-refund-shipment.png)

In this scenario, the shopper requests a return, and the seller approves the refund of the shipping cost. Meta sends an order patch request with `c_orderAction` as `refund_shipping_cost`, which triggers the `app.order.refund.processRefundShippingCostOrder` hook. This hook will provide the requested discount to the OMS. Subsequently, the OMS will return with an order patch request with `c_orderAction` as `update`, informing the amount and taxes to be applied as a price adjustment to the shipping line item.

Request from META to SFCC

OCAPI SHOP API - Update order - [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "refund_shipping_cost",
    "c_returnCase": {
        "requestor": "Customer",
        "shippingItems":{
                "me": {
                    "reason":"Unknown",
                    "note": "explanation of the refund",
                    "status" : "approved_external",
                    "type": "AmountWithoutTax",
                    "amount": -6.29
                    }
            }
        }
}
```

OCAPI SHOP API - Update order- [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "update",
    "product_items": [],
    "shipping_items": [
        {
            "c_reason": "Unknown",
            "c_shippingDiscount": -5.99,
            "c_taxDiscount": -0.30,
            "c_changeId": "1ocHr000000CxzMIAS",
            "c_externalLineItemStatus": 8
        }
    ]
}
```

## Appeasement

![Appeasement](./images/3p-oms-appeasement.png)

In this scenario, the shopper requests a return, and the seller approves the refund of both the product and the shipment. Meta sends an order patch request with `c_orderAction` as `appeasement`, which triggers the `app.order.refund.processAppeasementLineItems` hook. This hook will provide the requested discount to the OMS. Subsequently, the OMS will return with an order patch request with `c_orderAction` as `update`, informing the amount and taxes to be applied as a price adjustment to the line items and the shipping line item.

Request from META to SFCC

OCAPI SHOP API - Update order - [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "appeasement",
    "c_appeasement": {
        "requestor": "Customer",
        "appeasementItems": {
            "701642489030M":{
                "reason":"Unknown",
                "note": "explanation of the refund",
                "type": "AmountWithoutTax",
                "amount": -0.01
                }
            },
            "shippingItems":{
                "me": {
                    "reason":"Unknown",
                    "note": "explanation of the refund",
                    "type": "AmountWithoutTax",
                    "amount": -0.01
                    }
            }
        }
}
```

OCAPI SHOP API - Update order- [PATCH]
  `https://{host}/s/{siteId}/dw/shop/v24_1/orders/{order_no}`

```json
{
    "c_orderAction": "update",
    "product_items": [
        {
            "product_id": "701642489030M",
            "c_reason": "Unknown",
            "c_changeId": "1ocHr000000CxzSIAS",
            "c_productDiscount": -0.01,
            "c_taxDiscount": 0.00,
            "c_externalLineItemStatus": 9
        }
    ],
    "shipping_items": [
        {
            "c_reason": "Unknown",
            "c_shippingDiscount": -0.01,
            "c_taxDiscount": 0.00,
            "c_changeId": "1ocHr000000CxzRIAS",
            "c_externalLineItemStatus": 9
        }
    ]
}
```
