# Omnichannel Inventory (OCI) Integration

## Table of Contents
<details open><summary>Click to open/close</summary>

- [Collect Configuration Values](#collect-configuration-values)
- [Omnichannel Inventory Feed Installation](#omnichannel-inventory-feed-installation)
  - [Import OCI Data](#import-oci-data)
  - [OCI Service Configuration](#oci-service-configuration)
  - [OCI Job Configuration](#oci-job-configuration)
    - [Configure export list for location IDs and group IDs](#configure-export-list-for-location-ids-and-group-ids)
    - [Schedule OCI Jobs](#schedule-oci-jobs)

</details>

## Collect Configuration Values
To complete the OCI integration, you will need the following configuration values. Refer to the following [documentation](https://developer.salesforce.com/docs/commerce/commerce-api/guide/commerce-api-configuration-values.html) with help in finding these values:
1. **Short Code**: This value can be found by logging into Business Manager and proceeding to: **Administration** > **Site Development** > **Salesforce Commerce API Settings** > **Short Code** (e.g.: `kv7kzm78`)
2. **Organization ID**: This value can be found by logging into Business Manager and proceeding to: **Administration** > **Site Development** > **Salesforce Commerce API Settings** > **Organization ID** (e.g.: `f_ecom_zzte_053`)
![Salesforce Commerce API Settings](../docs/images/biz-mngr-scapi-config-values.png)

3. **OCI Tenant Group ID**: This value can be found by logging into your Salesforce Core Organization and proceeding to: **Setup** > **Feature Settings** > **Omnichannel Inventory**

![OCI Tenant Group ID](../docs/images/core-org-oci-tenant-group-id.png)

## Omnichannel Inventory Feed Installation
In case the storefront has [Omnichannel Inventory](https://help.salesforce.com/s/articleView?id=cc.b2c_inventory_management_omnichannel_inventory.htm) enabled, the native inventory export won't generate accurate inventory. The `int_socialfeeds` cartridge contains a set of jobs to export the inventory directly from OCI.

### Import OCI Data
> :rocket: **NOTE**: If you installed via b2c-tools, this step has already been completed. See [Install Social Integrations using b2c-tools](../README.md#install-social-integrations-using-b2c-tools).

OCI data is found in [data/oci_feeds](../data/oci_feeds).

#### Option 1: Via npm scripts using [sfcc-ci](https://github.com/SalesforceCommerceCloud/sfcc-ci)
1. From the root of the repo (`social_channel_integrations`), run: `npm run data:import:oci:feeds`
    - This will zip, upload, and import the data files into the sandbox specified in your dw.json file.

#### Option 2: Manually Zip, Upload, and Import via Business Manager
1. Zip the [data/oci_feeds](../data/oci_feeds) folder. From the root of the repo, run: `npm run data:oci:feeds:zip` (or manually zip the folder)
2. Log in to Business Manager
3. Go to **Administration** > **Site Development** > **Site Import & Export**
4. Click **Browse**
5. Select the `oci_feeds.zip` file from the root of the repo
6. Click **Upload**.
7. Select `oci_feeds.zip`
8. Click **Import**.
9. Click **OK**.

### OCI Service Configuration

#### Create API Client ID to use with OCI
1. Follow the steps to [Create an API Client](https://developer.salesforce.com/docs/commerce/commerce-api/guide/authorization-for-admin-apis.html#create-an-api-client)
   - **Allowed Scopes**:
     - `sfcc.inventory.admin.rw`
     - `sfcc.inventory.availability`
     - `sfcc.inventory.availability.rw`
     - `sfcc.inventory.impex-event-log`
     - `sfcc.inventory.impex-graphs`
     - `sfcc.inventory.impex-graphs.rw`
     - `sfcc.inventory.impex-inventory`
     - `sfcc.inventory.impex-inventory.rw`
     - `sfcc.inventory.reservations`
     - `sfcc.inventory.reservations.rw`
   - **Salesforce Commerce API role** (apply individual instance)
   - **Token Endpoint Auth Method**: `client_secret_post`
   - **Access Token Format**: `JWT`

![SCAPI API Client ID](../docs/images/scapi-client-id.png)

#### Configure Service Credentials
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Services**
3. Click the **Credentials** tab
4. Click **oci-export-auth**
5. Set **User** to your `API Client ID` created in the [Create API Client ID to use with OCI](#create-api-client-id-to-use-with-oci) step (e.g.: `d0221295-d2c5-4dc6-88a1-1d6ddf16dbfe`)
6. Set **Password** to your `API Client Secret/Password` created in the [Create API Client ID to use with OCI](#create-api-client-id-to-use-with-oci) step
7. Click **Apply**

![OCI Export Auth Credentials](../docs/images/biz-mngr-svc-cred-oci-export-auth.png)

8. Click **<<Back to List**
9. Click **oci-export-inventory**
10. In the **URL** field, replace `{{shortCode}}` with your Salesforce Commerce API Short Code (e.g.: `kv7kzm78`). Refer to [Collect Configuration Values](#collect-configuration-values)
11. Set **User** to your `OCI Tenant Group ID`. Refer to [Collect Configuration Values](#collect-configuration-values)
12. Click **Apply**

![OCI Export Inventory Credentials](../docs/images/biz-mngr-svc-cred-oci-export-inventory.png)

### OCI Job Configuration

#### Configure export list for location IDs and group IDs
1. Log in to Business Manager
2. Go to **Merchant Tools** > **Custom Objects** > **Custom Objects Editor**
3. From the _Object Type_ drop down, select **OCIExport**
4. Click **New**
   - **ID**: Enter any ID (e.g.: `oci-export-RefArch`). Supply to the **OCICustomObjectId** job param in OCI scheduled jobs in the next section.
   - **Organization ID**: Salesforce Commerce API Org ID (e.g.: `f_ecom_zzte_053`). Refer to [Collect Configuration Values](#collect-configuration-values)
   - **Location IDs to Export**: Comma separated location IDs that should be exported
   - **Location Group IDs to Export**: Comma separated location group IDs that should be exported
> Note: At least one of **Location IDs to Export** or **Location Group IDs to Export** must be provided
5. Click **Apply**

#### Schedule OCI Jobs
1. `OCI-Trigger-Export`: Triggers export of the OCI inventory based on the locations and location-groups provided to the job step param
    - Click on the **Job Steps** tab and configure job steps
      - **TriggerExport**
        - **OCICustomObjectId**: `OCIExport` custom object's ID (e.g.: `oci-export-RefArch`)
        - Click **Assign**
        - ![OCI Trigger Export](../docs/images/biz-mngr-oci-trigger-export.png)
    - Click on the **Schedule and History** tab and configure the job to run daily
2. `OCI-Download-Full-Inventory`: The `OCI-Trigger-Export` job should be run first to trigger the export and the download should be performed after some time the trigger job run, depending on data volume. This job downloads the triggered full export file into the provided folder path.
   - Click on the **Job Steps** tab and configure job steps
    - **Download Inventory File from OCI**
        - **FolderPath**: `feeds/export/oci/full`
        - **OCICustomObjectId**: `OCIExport` custom object's ID (e.g.: `oci-export-RefArch`)
        - Click **Assign**
        - ![OCI Download Full Inventory](../docs/images/biz-mngr-oci-download-full-inv.png)
    - For TikTok, add the `TikTokNotifyFeedReady` job step. Refer to the [TikTok instructions](./tiktok.md#omnichannel-inventory-oci-integration) for more details.
3. `OCI-Download-Delta-Inventory`: Downloads delta inventory from OCI based on the token saved in the custom cache. Note - uses token generated by the full feed export or the previous delta export.
    - Click on the **Job Steps** tab and configure job steps
      - **Delta Export**
          - **FolderPath**: `feeds/export/oci/delta`
          - **OCICustomObjectId**: `OCIExport` custom object's ID (e.g.: `oci-export-RefArch`)
          - Click **Assign**
          - ![OCI Download Delta Inventory](../docs/images/biz-mngr-oci-download-delta-inv.png)
      - For TikTok, add the `TikTokNotifyFeedReady` job step. Refer to the [TikTok instructions](./tiktok.md#omnichannel-inventory-oci-integration) for more details.
    - Click on the **Schedule and History** tab and configure the job to run every 1 hour
