# Social Product Feeds

## Table of Contents
<details open><summary>Click to open/close</summary>

- [User Interface](#user-interface)
- [Technical Outline](#technical-outline)
    - [System Attributes](#system-attributes)
    - [Custom Attributes](#custom-attributes)
    - [Active Data Attributes](#active-data-attributes)
    - [Special Attributes](#special-attributes)
- [CSV Example](#csv-example)
- [Storage Location](#storage-location)
    - [IMPEX Directory](#impex-directory)
    - [Static Directory](#static-directory)
- [Optional Jobsteps](#optional-jobsteps)
    - [Custom Feeds Delete](#custom-feeds-delete)
</details>

## User Interface
You can find the user interface via Business Manager at: **Administration** > **Social Product Feeds** > **Social Product Feeds Definition**

- ![biz-mngr-social-feeds](../docs/images/biz-mngr-social-feeds.png)

From here, you can create feeds, edit feeds, remove feeds, or modify existing feeds.

## Technical Outline
The configuration is represented by custom objects of type `SalesChannelFeedConfig`.

The component functionality uses the search functionality to iterate over all available products, handlers which are created using the configuration stored in the custom objects are then writing the export files into the configured locations.

### System Attributes
The following system attributes are supported:
- `EAN`
- `ID`
- `UPC`
- `brand`
- `creationDate`
- `facebookEnabled`
- `lastModified`
- `longDescription`
- `manufacturerName`
- `manufacturerSKU`
- `minOrderQuantity`
- `name`
- `onlineFlag`
- `onlineFrom`
- `onlineTo`
- `pageDescription`
- `pageKeywords`
- `pageTitle`
- `pageURL`
- `pinterestEnabled`
- `searchPlacement`
- `searchRank`
- `searchable`
- `searchableIfUnavailable`
- `shortDescription`
- `siteMapChangeFrequency`
- `siteMapIncluded`
- `siteMapPriority`
- `stepQuantity`
- `storeReceiptName`
- `storeTaxClass`
- `taxClassID`
- `template`
- `unit`

### Custom Attributes
Custom attributes can be defined by using the following syntax:
- `custom.color`
- `custom:color`

### Active Data Attributes
Active product data attributes can be defined by using the following syntax:
- `activeData.avgSalesPriceDay`
- `activeData.avgSalesPriceYear`

### Special Attributes
The following special attributes are supported and are treated like system attributes. All product field mappings can be found in [ProductFieldMapper.ds](../social_feeds/cartridges/int_socialfeeds/cartridge/scripts/export/ProductFieldMapper.ds).

| **Field Name**               | **Details**                                                                                                                                                                                                                                                                                              |
|------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| `adult`                      | `product.custom.adult` or `No`                                                                                                                                                                                                                                                                           |
| `age` or `ageGroup`          | `product.custom.kidsAge` or `adult`                                                                                                                                                                                                                                                                      |
| `all`                        | all custom attributes fields from `product.custom.*`                                                                                                                                                                                                                                                     |
| `ATS`                        | `inventoryRecord.getATS().value` or `0`                                                                                                                                                                                                                                                                  |
| `availability`               | string value based on `product.getAvailabilityModel().getAvailabilityStatus()` For Google social media (e.g.: `in_stock`, `out_of_stock`, `preorder`, `backorder`) for other social medias (e.g.: `in stock`, `out of stock`, `preorder`, `backorder`)                                                   |
| `availabilityDate`           | string value based on `product.getAvailabilityModel().getInventoryRecord().inStockDate` The date that the item is expected to be in stock. For `preorder` availability only. (`format: yyyy-MM-ddThh:mmZ`)                                                                                               |
| `bundledProducts`            | `product.bundledProducts` array when `product.bundle = true`                                                                                                                                                                                                                                             |
| `categoriesPath`             | category path of online categories; supports `sep` and `sep2` parameters (e.g.: `categoriesPath sep="," sep2 = ">"`)                                                                                                                                                                                     |
| `categoryPath`               | category path of primary category or first category assignment; supports `sep` parameter (e.g.: `categoryPath sep=" > "`                                                                                                                                                                                 |
| `category`                   | the display name of the primary category or empty                                                                                                                                                                                                                                                        |
| `categoryId`                 | the category ID of the primary category or empty                                                                                                                                                                                                                                                         |
| `categoryUrl`                | the category URL of the primary category or empty                                                                                                                                                                                                                                                        |
| `color`                      | `product.custom.refinementColor` or `None`                                                                                                                                                                                                                                                               |
| `condition`                  | `product.custom.condition` or `new`                                                                                                                                                                                                                                                                      |
| `countryCode`                | the uppercase ISO 3166 2-letter country/region code for the feed locale or the default locale                                                                                                                                                                                                            |
| `currencyCode`               | the site's default currency code                                                                                                                                                                                                                                                                         |
| `customData`                 | returns JSON of product custom attributes (e.g.: `customData attributes="c_tvSignalFormat,c_tvType,c_isNew,c_skinConcern,c_isSale"`)                                                                                                                                                                     |
| `defaultLocale`              | the site's default locale                                                                                                                                                                                                                                                                                |
| `description`                | the HTML markup of the `shortDescription` field if it exists, otherwise the HTML markup of the `longDescription` field if it exists                                                                                                                                                                      |
| `descriptionDetails`         | the combination of the product shortDescription and longDescription; supports the following parameters:<br/>`format="plainText"` (e.g.: `descriptionDetails format="plainText"` to remove html tags)<br/>`sep` parameter for joining short and long description (e.g.: `descriptionDetails sep="<br/>"`) |
| `gender`                     | `product.custom.gender` or product categories will search for the presence of **women** or **men** in the category name and set values to one of: `unisex`, `female`, `male`                                                                                                                             |
| `googleCartPermalink`        | Google permalink URL;  supports `attributes` parameter (e.g.: `googleCartPermalink attributes="checkout,true"`). With `checkout,true` value the generated URL redirects shoppers to ***Checkout*** page while `checkout,false` redirects shoppers to the ***Cart*** page. :warning: Using this attribute requires installing the cartridge [`int_google_checkout`](./google.md#update-cartridge-paths) to support the permalink feature. |
| `googleProductCategories`    | sets to the value selected for the **Google Shopping Category** field on the feed configuration page                                                                                                                                                                                                     |
| `image` or `additionalImage` | url to image; supports `type` parameter which allows to specify the view type, defaults to view type **large** (e.g.: `image type="zoom"`)                                                                                                                                                               |
| `imageJsonData`              | all images in JSON form; supports `type` parameter which allows to specify the view type, defaults to view type **large** (e.g.: `imageJsonData type="zoom"`)                                                                                                                                            |
| `isDefaultVariant`           | boolean; true for default variants or true for non-variant products (base, standard, etc products)                                                                                                                                                                                                       |
| `isAvailable`                | boolean; the `availabilityModel.orderable` value of the base product                                                                                                                                                                                                                                     |
| `isBundle`                   | boolean; the `product.bundle` value of the base product                                                                                                                                                                                                                                                  |
| `itemGroupId`                | if variant, the base product ID; supports `nonEmpty` for the `format` param which will default to the current product ID if no item group ID can be determined (e.g.: `item_group_id format="non_empty"`)                                                                                                |
| `landingUrl`                 | the product url string                                                                                                                                                                                                                                                                                   |
| `listPriceValue`             | the list price value based on `product.priceModel.price.currencyCode` + `'-m-list-prices'`; supports type `type` param to define the pricebook (e.g.: `listPriceValue type="eur-m-list-prices"`)                                                                                                         |
| `locale`                     | the current feed locale or the site's default locale                                                                                                                                                                                                                                                     |
| `metaCategoriesPath`         | exclusive for the Facebook and Instagram integration, this column adds a category tree object for the current product (if the Account Manager credential is not correctly configured on Facebook and Instagram module, this column will be empty)                                                        |
| `metaPricebooksPath`         | show a hierarchical list with product pricebook IDs                                                                                                                                                                                                                                                      |
| `onlineAndInStock`           | if the product is online and has available to sale (ATS) > 0 or is perpetual, value is `IN STOCK`, otherwise `NOT AVAILABLE`                                                                                                                                                                             |
| `price` or `priceValue`      | the product price; supports the following parameters:<br/>`format` (e.g.: `price format="promotionPricing"` to get the sale or promo price)<br/>`type` - (e.g.: `price type="eur-m-list-prices"` to get specific pricebook price)                                                                        |
| `pricebookId`                | show the current pricebook ID of the product                                                                                                                                                                                                                                                             |
| `priceGoogle`                | uses SFRA price model and factory to determine price; supports the `format="promotionPricing"` parameter which returns the sale or promo price (e.g.: `priceGoogle format="promotionPricing"`)                                                                                                           |
| `productDeeplink`            | the url to edit the base product attributes on Business Manager (for *`Channel Type=Instagram`*, this attribute will always be included)                                                                                                                                                                 |
| `productDescription`         | `product.shortDescription` with HTML removed                                                                                                                                                                                                                                                             |
| `productLiveDate`            | product live date based on calculation from inventory record `creationDate` and `product.onlineFrom`                                                                                                                                                                                                     |
| `productTitle`               | `product.pageTitle` or `product.name`                                                                                                                                                                                                                                                                    |
| `salePriceValue`             | the sale price value based on `product.priceModel.price.currencyCode` + `'-m-sale-prices'`; supports type `type` param to define the pricebook (e.g.: `salePriceValue type="eur-m-list-prices"`)                                                                                                         |
| `shippingMethod`             | the display name of the site's default shipping method                                                                                                                                                                                                                                                   |
| `shippingPrice`              | the shipping price for the default shipping method based on the product's priceModel price                                                                                                                                                                                                               |
| `shippingPriceValue`         | the shipping price value for the default shipping method based on the product's priceModel price                                                                                                                                                                                                         |
| `siteName`                   | the storefront site name                                                                                                                                                                                                                                                                                 |
| `size`                       | for variant products, returns the `size` variation value                                                                                                                                                                                                                                                 |
| `sizeAvailable`              | list all sizes options for the base product; supports `sep` parameter (e.g.: `sizeAvailable sep=">"`)                                                                                                                                                                                                    |
| `sizeDisplayValue`           | for variant products, returns the `size` variation display value                                                                                                                                                                                                                                         |
| `stock`                      | value of `availabilityModel.availability` for the base product                                                                                                                                                                                                                                           |
| `stockAvailability`          | `in stock` or `out of stock` based on for `availabilityModel.inStock` for the base product                                                                                                                                                                                                               |
| `timestamp`                  | current time stamp; supports `format` parameter (e.g.: `timestamp format="yyyyMMddhhmmss"`)                                                                                                                                                                                                              |
| `url`                        | the product url                                                                                                                                                                                                                                                                                          |
| `variationJsonData`          | stringified JSON object of all variation attribute data                                                                                                                                                                                                                                                  |

## CSV Example
```
separator |
SKU,Name,Price in EUR,Color, Custom Data
ID,name,price type="eur-m-list-prices",custom.color,customData attributes="c_tvSignalFormat,c_tvType,c_isNew,c_skinConcern,c_isSale"
```

The line specifying the separator is optional, if it is omitted "," will be used.

The next line defines the header and will be printed into the CSV without modifications.

The last line is the definition of the fields, the same fields as for XML feeds can be used. Custom attributes are prefixed with `custom.`

## Storage Location
The feeds are placed in a folder specified by `Folder Name`. This supports all locations which are supported by dw.io.File. Here are two common use cases:

### IMPEX Directory
> NOTE: This is not accessible from the outside world unless a Business Manager account or WebDAV Client ID with the proper access exists:
`IMPEX/src/feeds/export/social/tiktok/product`

### Static Directory
Export the file to the content static directory to make it publicly accessible. Feed will then be available under i.e.: https://dev01-web-realm.demandware.net/on/demandware.static/Sites-Site/Sites-SiteGenesis-Library/default/v1374716564121/feeds/mycsv_20130801062925.csv
`LIBRARIES/RefArch/default/feeds`

The filename can (and must) be specified as well, it additionally supports the following placeholders:
- `{{timestamp}}` - gets replaced with the timestamp, supports optional format="DATE_FORMAT", i.e. {{timestamp format="yyyyMMdd"}})
- `{{site_id}}` - gets replaced with the Site ID (`RefArch`, `RefArchGlobal`)
- `{{updateType}}` - gets replaced with the file's update type (`full`, `delta`)
- `{{siteName}}` -  gets replaced with the Site Name
- `{{countrycode}}` - gets replaced with the two digit country code based on default locale
- `{{languagecode}}` - gets replaced with the 3-letter ISO 639 language code for the default locale
- `{{locale}}` - gets replaced with the site's default locale

## Optional Jobsteps
There is a list of optional job steps that can be added to any new or existing job to help manage the generated feed files.

### Custom Feeds Delete
This job step can be used to remove old files from a specific WebDAV folder.
1. Log in to Business Manager
2. Go to **Administration** > **Operations** > **Jobs**
3. Click on an existing job to modify it or create a new one
4. Click on the **Job Steps** tab and add this step at the desired position: `custom.CustomFeeds.Delete`
    - The following table shows the main attributes available:
        | **Step Parameter**     | **Description**                                                             |
        |------------------------|-----------------------------------------------------------------------------|
        | OlderThanDays          | Delete file older than X days                                               |
        | FolderPath             | Path relative to 'IMPEX'                                                    |
        | FileExtension          | File extension. (e.g:. all, txt, csv, etc)                                  |
        | DeleteFileInSubfolders | Delete file in subfolders                                                   |
    - ![Custom Feed Delete](../docs/images/job-delete-feed-jobstep.png)
    - Click **Assign**